/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.client.IntegrationGroupConfiguration;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupElement;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.oif.client.rest.OpenIntegrationRESTClient;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorsResponse;

public abstract class IntegrationGroupConfigurationClientBase
extends IntegrationGroupConfiguration {
    private final OpenIntegrationRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private AuditLog auditLog = null;

    public IntegrationGroupConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new OpenIntegrationRESTClient(serverName, serverPlatformURLRoot);
    }

    public IntegrationGroupConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new OpenIntegrationRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public IntegrationGroupConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, OpenIntegrationRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    @Override
    public String createIntegrationGroup(String userId, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationGroup";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "createIntegrationGroup");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationGroup");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/by-name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationGroupByName");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getElement();
    }

    @Override
    public List<IntegrationGroupElement> getAllIntegrationGroups(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationGroups";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationGroups");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse restResult = this.restClient.callIntegrationGroupsGetRESTCall("getAllIntegrationGroups", urlTemplate, this.serverName, this.serviceURLMarker, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void updateIntegrationGroup(String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/update?isMergeUpdate={4}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateIntegrationGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationGroup");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, guid, isMergeUpdate);
    }

    @Override
    public void deleteIntegrationGroup(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationGroup");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationGroup");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationGroup", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public String createIntegrationConnector(String userId, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationConnector";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationConnector");
        this.invalidParameterHandler.validateObject(properties, "properties", "createIntegrationConnector");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationConnector");
        this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "createIntegrationConnector");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationConnector", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/by-name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getElement();
    }

    @Override
    public List<IntegrationConnectorElement> getAllIntegrationConnectors(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse restResult = this.restClient.callIntegrationConnectorsGetRESTCall("getAllIntegrationConnectors", urlTemplate, this.serverName, this.serviceURLMarker, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public List<String> getIntegrationConnectorRegistrations(String userId, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorRegistrations";
        String guidParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorRegistrations");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getIntegrationConnectorRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getIntegrationConnectorRegistrations", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID);
        return restResult.getGUIDs();
    }

    @Override
    public void updateIntegrationConnector(String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationConnector";
        String guidParameterName = "guid";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/update?isMergeUpdate={4}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationConnector");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateIntegrationConnector");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationConnector");
            this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "updateIntegrationConnector");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationConnector", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, guid, isMergeUpdate);
    }

    @Override
    public void deleteIntegrationConnector(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationConnector";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationConnector");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationConnector");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationConnector", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public void registerIntegrationConnectorWithGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerIntegrationConnectorWithGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors{4}";
        this.invalidParameterHandler.validateUserId(userId, "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "registerIntegrationConnectorWithGroup");
        this.restClient.callVoidPostRESTCall("registerIntegrationConnectorWithGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnector";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse restResult = this.restClient.callRegisteredIntegrationConnectorGetRESTCall("getRegisteredIntegrationConnector", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
        return restResult.getRegisteredIntegrationConnector();
    }

    @Override
    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String userId, String integrationGroupGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnectors";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse restResult = this.restClient.callRegisteredIntegrationConnectorsGetRESTCall("getRegisteredIntegrationConnectors", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void unregisterIntegrationConnectorFromGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "unregisterIntegrationConnectorFromGroup");
        this.restClient.callVoidPostRESTCall("unregisterIntegrationConnectorFromGroup", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public void addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject(properties, "properties", "addCatalogTarget");
        this.restClient.callVoidPostRESTCall("addCatalogTarget", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
    }

    @Override
    public CatalogTarget getCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTarget");
        CatalogTargetResponse restResult = this.restClient.callCatalogTargetGetRESTCall("getCatalogTarget", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
        return restResult.getElement();
    }

    @Override
    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        CatalogTargetsResponse restResult = this.restClient.callCatalogTargetsGetRESTCall("getCatalogTargets", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void removeCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "removeCatalogTarget");
        this.restClient.callVoidPostRESTCall("removeCatalogTarget", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
    }
}

