/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Differences {
    protected Map<String, ValuePair> differing = new TreeMap<String, ValuePair>();
    protected Map<String, Object> matching = new TreeMap<String, Object>();
    protected Map<String, Object> onlyOnLeft = new TreeMap<String, Object>();
    protected Map<String, Object> onlyOnRight = new TreeMap<String, Object>();

    public boolean hasDifferences() {
        return !this.differing.isEmpty() || !this.onlyOnLeft.isEmpty() || !this.onlyOnRight.isEmpty();
    }

    public Set<String> getNames() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.differing.keySet());
        set.addAll(this.onlyOnLeft.keySet());
        set.addAll(this.onlyOnRight.keySet());
        return set;
    }

    public boolean isDifferent(String name) {
        return this.differing.containsKey(name) || this.onlyOnLeft.containsKey(name) || this.onlyOnRight.containsKey(name);
    }

    public Object getLeftValue(String name) {
        if (this.onlyOnLeft.containsKey(name)) {
            return this.onlyOnLeft.get(name);
        }
        if (this.onlyOnRight.containsKey(name)) {
            return null;
        }
        if (this.differing.containsKey(name)) {
            return this.differing.get(name).getLeft();
        }
        return this.matching.get(name);
    }

    public Object getRightValue(String name) {
        if (this.onlyOnRight.containsKey(name)) {
            return this.onlyOnRight.get(name);
        }
        if (this.onlyOnLeft.containsKey(name)) {
            return null;
        }
        if (this.differing.containsKey(name)) {
            return this.differing.get(name).getRight();
        }
        return this.matching.get(name);
    }

    public Map<String, Object> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Map<String, Object> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public void check(String name, Object left, Object right) {
        if (left == null && right == null) {
            this.addMatching(name, null);
        } else if (left == null) {
            this.onlyOnRight.put(name, right);
        } else if (right == null) {
            this.onlyOnLeft.put(name, left);
        } else if (left.equals(right)) {
            this.addMatching(name, left);
        } else {
            this.addDiffering(name, new ValuePair(left, right));
        }
    }

    public void addOnlyOnOneSide(SidePresent side, String name, Object value) {
        if (side.equals((Object)SidePresent.LEFT_ONLY)) {
            this.onlyOnLeft.put(name, value);
        } else if (side.equals((Object)SidePresent.RIGHT_ONLY)) {
            this.onlyOnRight.put(name, value);
        }
    }

    protected void addMatching(String name, Object value) {
        this.matching.put(name, value);
    }

    protected void addDiffering(String name, ValuePair valuePair) {
        this.differing.put(name, valuePair);
    }

    public static class ValuePair {
        private final Object left;
        private final Object right;

        ValuePair(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        Object getLeft() {
            return this.left;
        }

        Object getRight() {
            return this.right;
        }
    }

    public static enum SidePresent {
        LEFT_ONLY,
        RIGHT_ONLY,
        NEITHER,
        BOTH;

    }
}

