/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectTeamMember;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectTeamProperties;

public class TeamMemberConverter<B>
extends OpenMetadataConverterBase<B> {
    public TeamMemberConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectTeamMember) {
                ProjectTeamMember bean = (ProjectTeamMember)returnBean;
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                if (relatedMetadataElement.getRelationshipProperties() != null) {
                    ProjectTeamProperties projectTeamProperties = new ProjectTeamProperties();
                    ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                    projectTeamProperties.setTeamRole(this.removeTeamRole(elementProperties));
                    projectTeamProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
                    projectTeamProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
                    projectTeamProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                    bean.setProjectTeamProperties(projectTeamProperties);
                }
                bean.setMember(super.getElementStub(beanClass, relatedMetadataElement.getElement(), methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

