/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataCollectionDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataPrimitiveDefCategory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataCollectionDef
extends OpenMetadataAttributeTypeDef {
    private OpenMetadataCollectionDefCategory collectionDefCategory = null;
    private int argumentCount = 0;
    private List<OpenMetadataPrimitiveDefCategory> argumentTypes = null;

    public OpenMetadataCollectionDef() {
        super(OpenMetadataAttributeTypeDefCategory.COLLECTION);
    }

    public OpenMetadataCollectionDef(OpenMetadataCollectionDefCategory collectionDefCategory) {
        super(OpenMetadataAttributeTypeDefCategory.COLLECTION);
        this.collectionDefCategory = collectionDefCategory;
        this.argumentCount = collectionDefCategory.getArgumentCount();
        this.argumentTypes = new ArrayList<OpenMetadataPrimitiveDefCategory>();
        for (int i = 0; i < this.argumentCount; ++i) {
            this.argumentTypes.add(OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
        }
    }

    public OpenMetadataCollectionDef(OpenMetadataCollectionDef template) {
        super(template);
        if (template != null) {
            this.collectionDefCategory = template.getCollectionDefCategory();
            this.argumentCount = template.getArgumentCount();
            this.setArgumentTypes(template.getArgumentTypes());
        }
    }

    @Override
    public OpenMetadataAttributeTypeDef cloneFromSubclass() {
        return new OpenMetadataCollectionDef(this);
    }

    public OpenMetadataCollectionDefCategory getCollectionDefCategory() {
        return this.collectionDefCategory;
    }

    public void setCollectionDefCategory(OpenMetadataCollectionDefCategory collectionDefCategory) {
        this.collectionDefCategory = collectionDefCategory;
        this.argumentCount = collectionDefCategory.getArgumentCount();
        this.argumentTypes = new ArrayList<OpenMetadataPrimitiveDefCategory>();
        for (int i = 0; i < this.argumentCount; ++i) {
            this.argumentTypes.add(OpenMetadataPrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
        }
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public void setArgumentCount(int argumentCount) {
    }

    public List<OpenMetadataPrimitiveDefCategory> getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setArgumentTypes(List<OpenMetadataPrimitiveDefCategory> argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @Override
    public String toString() {
        return "OpenMetadataCollectionDef{name='" + this.name + "', collectionDefCategory=" + this.collectionDefCategory + ", argumentCount=" + this.argumentCount + ", argumentTypes=" + this.argumentTypes + ", category=" + this.category + ", guid='" + this.guid + "', description='" + this.description + "', descriptionGUID='" + this.descriptionGUID + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataCollectionDef that = (OpenMetadataCollectionDef)objectToCompare;
        return this.argumentCount == that.argumentCount && this.collectionDefCategory == that.collectionDefCategory && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.collectionDefCategory, this.argumentCount, this.argumentTypes});
    }
}

