/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.ConnectedAssetContext;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationGovernanceContext;
import org.odpi.openmetadata.frameworks.integration.context.MultiLanguageManagement;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.context.StewardshipAction;
import org.odpi.openmetadata.frameworks.integration.context.ValidMetadataValuesContext;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FilesListenerManager;
import org.odpi.openmetadata.frameworks.integration.reports.IntegrationReportWriter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class IntegrationContext {
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final OpenIntegrationClient openIntegrationClient;
    protected final ActionControlInterface actionControlInterface;
    protected final GovernanceConfiguration governanceConfiguration;
    protected final OpenMetadataClient openMetadataStoreClient;
    protected final String userId;
    protected final String connectorName;
    protected final String integrationConnectorGUID;
    protected final PermittedSynchronization permittedSynchronization;
    protected String externalSourceGUID;
    protected String externalSourceName;
    protected boolean externalSourceIsHome = true;
    protected final FileClassifier fileClassifier;
    private final ConnectedAssetContext connectedAssetContext;
    private final IntegrationGovernanceContext integrationGovernanceContext;
    protected final IntegrationReportWriter integrationReportWriter;
    private final Map<String, String> externalSourceCache = new HashMap<String, String>();
    protected final int maxPageSize;
    private final FilesListenerManager listenerManager;
    private boolean isRefreshInProgress = false;

    public IntegrationContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, GovernanceConfiguration governanceConfiguration, OpenMetadataClient openMetadataStoreClient, ActionControlInterface actionControlInterface, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String externalSourceGUID, String externalSourceName, String integrationConnectorGUID, AuditLog auditLog, int maxPageSize) {
        this.openIntegrationClient = openIntegrationClient;
        this.governanceConfiguration = governanceConfiguration;
        this.openMetadataStoreClient = openMetadataStoreClient;
        this.actionControlInterface = actionControlInterface;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = connectorUserId;
        this.connectorName = connectorName;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.integrationConnectorGUID = integrationConnectorGUID;
        this.maxPageSize = maxPageSize;
        this.fileClassifier = new FileClassifier(new OpenMetadataStore(openMetadataStoreClient, this.userId, integrationConnectorGUID));
        this.listenerManager = new FilesListenerManager(auditLog, connectorName);
        this.integrationReportWriter = generateIntegrationReport ? new IntegrationReportWriter(serverName, connectorId, connectorName, this.userId, openIntegrationClient, openMetadataStoreClient) : null;
        this.connectedAssetContext = new ConnectedAssetContext(connectorUserId, openIntegrationClient);
        this.integrationGovernanceContext = this.constructIntegrationGovernanceContext(openMetadataStoreClient, actionControlInterface, connectorUserId, externalSourceGUID, externalSourceName, integrationConnectorGUID, this.integrationReportWriter);
    }

    private IntegrationGovernanceContext constructIntegrationGovernanceContext(OpenMetadataClient openMetadataStore, ActionControlInterface actionControlInterface, String userId, String externalSourceGUID, String externalSourceName, String originatorGUID, IntegrationReportWriter integrationReportWriter) {
        if (this.openMetadataStoreClient != null) {
            OpenMetadataAccess openMetadataAccess = new OpenMetadataAccess(openMetadataStore, userId, externalSourceGUID, externalSourceName, originatorGUID, integrationReportWriter);
            MultiLanguageManagement multiLanguageManagement = new MultiLanguageManagement(openMetadataStore, userId);
            StewardshipAction stewardshipAction = new StewardshipAction(openMetadataStore, actionControlInterface, userId, originatorGUID);
            ValidMetadataValuesContext validMetadataValuesContext = new ValidMetadataValuesContext(openMetadataStore, userId);
            return new IntegrationGovernanceContext(openMetadataAccess, multiLanguageManagement, stewardshipAction, validMetadataValuesContext);
        }
        return null;
    }

    public String getMyUserId() {
        return this.userId;
    }

    public FileClassifier getFileClassifier() {
        return this.fileClassifier;
    }

    public boolean elementShouldBeCatalogued(String elementName, List<String> excludedNames, List<String> includedNames) {
        if (elementName == null) {
            return false;
        }
        if (includedNames != null) {
            return includedNames.contains(elementName);
        }
        if (excludedNames != null) {
            return !excludedNames.contains(elementName);
        }
        return true;
    }

    public String addCatalogTarget(String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && this.integrationConnectorGUID != null) {
            return this.governanceConfiguration.addCatalogTarget(this.userId, this.integrationConnectorGUID, metadataElementGUID, properties);
        }
        return null;
    }

    public String addCatalogTarget(String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && integrationConnectorGUID != null) {
            return this.governanceConfiguration.addCatalogTarget(this.userId, integrationConnectorGUID, metadataElementGUID, properties);
        }
        return null;
    }

    public void updateCatalogTarget(String relationshipGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && this.integrationConnectorGUID != null) {
            this.governanceConfiguration.updateCatalogTarget(this.userId, relationshipGUID, properties);
        }
    }

    public CatalogTarget getCatalogTarget(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && this.integrationConnectorGUID != null) {
            return this.governanceConfiguration.getCatalogTarget(this.userId, relationshipGUID);
        }
        return null;
    }

    public List<CatalogTarget> getCatalogTargets(String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && integrationConnectorGUID != null) {
            return this.governanceConfiguration.getCatalogTargets(this.userId, integrationConnectorGUID, startingFrom, maximumResults);
        }
        return null;
    }

    public List<CatalogTarget> getCatalogTargets(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && this.integrationConnectorGUID != null) {
            return this.governanceConfiguration.getCatalogTargets(this.userId, this.integrationConnectorGUID, startingFrom, maximumResults);
        }
        return null;
    }

    public void removeCatalogTarget(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceConfiguration != null && this.integrationConnectorGUID != null) {
            this.governanceConfiguration.removeCatalogTarget(this.userId, relationshipGUID);
        }
    }

    public String getMetadataSourceQualifiedName() {
        return this.externalSourceName;
    }

    public String getMetadataSourceGUID() {
        return this.externalSourceGUID;
    }

    public void setMetadataSourceQualifiedName(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (metadataSourceQualifiedName == null) {
            this.externalSourceName = null;
            this.externalSourceGUID = null;
        } else if (this.externalSourceCache.get(metadataSourceQualifiedName) != null) {
            this.externalSourceName = metadataSourceQualifiedName;
            this.externalSourceGUID = this.externalSourceCache.get(metadataSourceQualifiedName);
        } else {
            String metadataSourceGUID = this.openMetadataStoreClient.getMetadataElementGUIDByUniqueName(this.userId, metadataSourceQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, false, false, null, new Date());
            if (metadataSourceGUID != null) {
                this.externalSourceName = metadataSourceQualifiedName;
                this.externalSourceGUID = metadataSourceGUID;
                this.externalSourceCache.put(metadataSourceQualifiedName, metadataSourceGUID);
            }
        }
        this.integrationGovernanceContext.setExternalSourceIds(this.externalSourceGUID, this.externalSourceName);
    }

    public void setMetadataSourceQualifiedName(String metadataSourceGUID, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (metadataSourceQualifiedName == null) {
            this.externalSourceName = null;
            this.externalSourceGUID = null;
        } else {
            this.externalSourceName = metadataSourceQualifiedName;
            this.externalSourceGUID = metadataSourceGUID;
            this.externalSourceCache.put(metadataSourceQualifiedName, metadataSourceGUID);
        }
        this.integrationGovernanceContext.setExternalSourceIds(this.externalSourceGUID, this.externalSourceName);
    }

    public boolean getExternalSourceIsHome() {
        return this.externalSourceIsHome;
    }

    public void setExternalSourceIsHome(boolean newValue) {
        this.externalSourceIsHome = newValue;
    }

    public PermittedSynchronization getPermittedSynchronization() {
        return this.permittedSynchronization;
    }

    public IntegrationGovernanceContext getIntegrationGovernanceContext() {
        return this.integrationGovernanceContext;
    }

    public ConnectedAssetContext getConnectedAssetContext() {
        return this.connectedAssetContext;
    }

    public void setActiveReportPublishing(boolean flag) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setActiveReportPublishing(flag);
        }
    }

    void startRecording() {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.startRecording();
        }
    }

    protected void reportAnchorGUID(String elementGUID, String anchorGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(elementGUID, anchorGUID);
        }
    }

    protected void reportAnchorGUID(String elementGUID, String anchorGUID, String anchorTypeName) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(elementGUID, anchorGUID, anchorTypeName);
        }
    }

    protected void reportParentGUID(String elementGUID, String parentGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(elementGUID, parentGUID);
        }
    }

    protected void reportElementCreation(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(elementGUID);
        }
    }

    protected void reportElementUpdate(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    protected void reportElementDelete(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(elementGUID);
        }
    }

    void publishReport() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.publishReport();
        }
    }

    public boolean isRefreshInProgress() {
        return this.isRefreshInProgress;
    }

    void setRefreshInProgress(boolean refreshInProgress) {
        this.isRefreshInProgress = refreshInProgress;
    }

    public String getAnchorGUID(ElementHeader elementHeader) {
        if (elementHeader.getClassifications() != null) {
            for (ElementClassification classification : elementHeader.getClassifications()) {
                Object anchorGUID;
                Map<String, Object> properties;
                if (!classification.getClassificationName().equals(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName) || (properties = classification.getClassificationProperties()) == null || (anchorGUID = properties.get(OpenMetadataProperty.ANCHOR_GUID.name)) == null) continue;
                return anchorGUID.toString();
            }
        }
        return null;
    }

    public String getAnchorGUID(OpenMetadataElement openMetadataElement) {
        String methodName = "getAnchorGUID";
        if (openMetadataElement.getClassifications() != null) {
            for (AttachedClassification classification : openMetadataElement.getClassifications()) {
                if (!classification.getClassificationName().equals(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName)) continue;
                return this.propertyHelper.getStringProperty(this.connectorName, OpenMetadataProperty.ANCHOR_GUID.name, classification.getClassificationProperties(), "getAnchorGUID");
            }
        }
        return null;
    }

    public void registerFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        this.listenerManager.registerFileListener(listener, fileToMonitor);
    }

    public void unregisterFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterFileListener(listener, fileToMonitor);
    }

    public void registerDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        this.listenerManager.registerDirectoryListener(listener, directoryToMonitor, fileFilter);
    }

    public void unregisterDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterDirectoryListener(listener, directoryToMonitor);
    }

    public void registerDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        this.listenerManager.registerDirectoryTreeListener(listener, directoryToMonitor, fileFilter);
    }

    public void unregisterDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterDirectoryTreeListener(listener, directoryToMonitor);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public boolean isTypeOf(ElementHeader elementHeader, String typeName) {
        return this.isTypeOf(elementHeader.getType(), typeName);
    }

    public boolean isTypeOf(ElementType elementType, String typeName) {
        if (elementType != null) {
            ArrayList<String> elementTypeNames = new ArrayList<String>();
            elementTypeNames.add(elementType.getTypeName());
            if (elementType.getSuperTypeNames() != null) {
                elementTypeNames.addAll(elementType.getSuperTypeNames());
            }
            if (elementTypeNames.contains(typeName)) {
                return true;
            }
        }
        return false;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.listenerManager != null) {
            this.listenerManager.disconnect();
        }
    }
}

