/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CommunityMembershipType implements OpenMetadataEnum
{
    CONTRIBUTOR(0, "959cae9b-218f-4254-8a79-721d568372bd", "Contributor", "Individual is able to be a contributing member of the community.", true),
    ADMINISTRATOR(1, "35201771-3ca2-4b7a-9dd1-77aa0224abe8", "Administrator", "Individual is able to administer the community.", false),
    LEADER(2, "d4f5dfdc-39d6-47c1-8dfb-077b5f7244d7", "Leader", "Individual sets the direction of the community.", false),
    OBSERVER(3, "c1bd838c-f5be-4464-aee9-bcf0ff07ec32", "Observer", "Individual is receiving notifications about the community.", false),
    OTHER(99, "1c9fd81c-d22a-4aca-b2f3-469088ff7887", "Other", "Another meaning.", false);

    private static final String ENUM_TYPE_GUID = "b0ef45bf-d12b-4b6f-add6-59c14648d750";
    private static final String ENUM_TYPE_NAME = "CommunityMembershipType";
    private static final String ENUM_DESCRIPTION = "Type of membership to a community.";
    private static final String ENUM_DESCRIPTION_GUID = "69eeac39-f405-4196-97af-d25910fb93b6";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/1/0140-Communities/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private CommunityMembershipType(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null);
    }

    public String toString() {
        return "CommunityMembershipType : " + this.name;
    }
}

