/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.mapper;

public class OpenMetadataValidValues {
    public static final String CONNECTOR_FRAMEWORK_NAME_DEFAULT = "Open Connector Framework (OCF)";
    public static final String CONNECTOR_INTERFACE_LANGUAGE_DEFAULT = "Java";
    public static final String OPEN_METADATA_ECOSYSTEM_SCOPE = "Open Metadata Ecosystem";
    public static final String VALID_METADATA_VALUES_USAGE = "Used to control valid values in open metadata.";
    public static final String VALID_METADATA_VALUES_SET_CATEGORY = "Open Metadata Valid Values";
    public static final String VALID_METADATA_VALUES_QUALIFIED_NAME_PREFIX = "Egeria:ValidMetadataValue:";
    public static final String VALID_METADATA_VALUE_IS_TYPE_OF = "isATypeOf";
    public static final String ASSET_SUB_TYPE_NAME = "assetSubTypeName";

    public static String constructValidValueQualifiedName(String incomingTypeName, String incomingPropertyName, String incomingMapName, String incomingPreferredValue) {
        Object qualifiedName = VALID_METADATA_VALUES_QUALIFIED_NAME_PREFIX;
        String typeName = incomingTypeName;
        String propertyName = incomingPropertyName;
        String mapName = incomingMapName;
        String preferredValue = incomingPreferredValue;
        if (typeName != null && typeName.isBlank()) {
            typeName = null;
        }
        if (propertyName != null && propertyName.isBlank()) {
            propertyName = null;
        }
        if (mapName != null && mapName.isBlank()) {
            mapName = null;
        }
        if (preferredValue != null && preferredValue.isBlank()) {
            preferredValue = null;
        }
        if (typeName != null || propertyName != null) {
            qualifiedName = typeName != null ? (String)qualifiedName + typeName + ":" : (String)qualifiedName + ":";
            if (propertyName != null) {
                qualifiedName = (String)qualifiedName + propertyName + "-";
                if (mapName != null) {
                    qualifiedName = (String)qualifiedName + "-" + mapName + "--";
                }
                if (preferredValue != null) {
                    qualifiedName = (String)qualifiedName + "(" + preferredValue + ")";
                }
            }
        }
        return qualifiedName;
    }

    public static String constructValidValueCategory(String incomingTypeName, String incomingPropertyName, String incomingMapName) {
        String propertyNameStartSpacer = ":";
        String mapNameStartSpacer = "-";
        String mapNameEndSpacer = "--";
        String typeName = incomingTypeName;
        String propertyName = incomingPropertyName;
        String mapName = incomingMapName;
        if (typeName != null && typeName.isBlank()) {
            typeName = null;
        }
        if (propertyName != null && propertyName.isBlank()) {
            propertyName = null;
        }
        if (mapName != null && mapName.isBlank()) {
            mapName = null;
        }
        if (typeName != null) {
            if (propertyName != null) {
                if (mapName != null) {
                    return typeName + ":" + propertyName + "-" + mapName + "--";
                }
                return typeName + ":" + propertyName;
            }
            if (mapName != null) {
                return typeName + "-" + mapName + "--";
            }
            return typeName;
        }
        if (propertyName != null) {
            if (mapName != null) {
                return ":" + propertyName + "-" + mapName + "--";
            }
            return ":" + propertyName;
        }
        if (mapName != null) {
            return "-" + mapName + "--";
        }
        return VALID_METADATA_VALUES_SET_CATEGORY;
    }
}

