/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ArchiveProperties {
    private Date archiveDate = null;
    private String archiveProcess = null;
    private Map<String, String> archiveProperties = null;

    public ArchiveProperties() {
    }

    public ArchiveProperties(ArchiveProperties template) {
        if (template != null) {
            this.archiveDate = template.getArchiveDate();
            this.archiveProcess = template.getArchiveProcess();
            this.archiveProperties = template.getArchiveProperties();
        }
    }

    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public String getArchiveProcess() {
        return this.archiveProcess;
    }

    public void setArchiveProcess(String archiveProcess) {
        this.archiveProcess = archiveProcess;
    }

    public Map<String, String> getArchiveProperties() {
        if (this.archiveProperties == null) {
            return null;
        }
        if (this.archiveProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.archiveProperties);
    }

    public void setArchiveProperties(Map<String, String> archiveProperties) {
        this.archiveProperties = archiveProperties;
    }

    public String toString() {
        return "ArchiveProperties{archiveDate=" + this.archiveDate + ", archiveProcess='" + this.archiveProcess + "', archiveProperties='" + this.archiveProperties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ArchiveProperties that = (ArchiveProperties)objectToCompare;
        return Objects.equals(this.archiveDate, that.archiveDate) && Objects.equals(this.archiveProcess, that.archiveProcess) && Objects.equals(this.archiveProperties, that.archiveProperties);
    }

    public int hashCode() {
        return Objects.hash(this.archiveDate, this.archiveProcess, this.archiveProperties);
    }
}

