/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentProperties
extends RelationshipProperties {
    private static final String deploymentTimeProperty = "deploymentTime";
    private static final String deployerProperty = "deployer";
    private static final String deployerTypeNameProperty = "deployerTypeName";
    private static final String deployerPropertyNameProperty = "deployerPropertyName";
    private static final String deploymentStatusProperty = "deploymentStatus";
    private Date deploymentTime = null;
    private String deployer = null;
    private String deployerTypeName = null;
    private String deployerPropertyName = null;
    private OperationalStatus deploymentStatus = null;

    public DeploymentProperties() {
    }

    public DeploymentProperties(DeploymentProperties template) {
        super(template);
        if (template != null) {
            this.deploymentTime = template.getDeploymentTime();
            this.deployer = template.getDeployer();
            this.deployerTypeName = template.getDeployerTypeName();
            this.deployerPropertyName = template.getDeployerPropertyName();
            this.deploymentStatus = template.getDeploymentStatus();
        }
    }

    public DeploymentProperties(Map<String, Object> properties, Date effectiveFrom, Date effectiveTo) {
        super.setEffectiveFrom(effectiveFrom);
        super.setEffectiveTo(effectiveTo);
        if (properties != null) {
            this.deploymentTime = (Date)properties.get(deploymentTimeProperty);
            this.deployer = properties.get(deployerProperty).toString();
            this.deployerTypeName = properties.get(deployerTypeNameProperty).toString();
            this.deployerPropertyName = properties.get(deployerPropertyNameProperty).toString();
            this.deploymentStatus = OperationalStatus.DISABLED;
            int operationalStatus = (Integer)properties.get(deploymentStatusProperty);
            if (operationalStatus == 1) {
                this.deploymentStatus = OperationalStatus.ENABLED;
            }
        }
    }

    public Map<String, Object> cloneToMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        if (this.deploymentTime != null) {
            propertyMap.put(deploymentTimeProperty, this.deploymentTime);
        }
        if (this.deployer != null) {
            propertyMap.put(deployerProperty, this.deployer);
        }
        if (this.deployerTypeName != null) {
            propertyMap.put(deployerTypeNameProperty, this.deployerTypeName);
        }
        if (this.deployerPropertyName != null) {
            propertyMap.put(deployerPropertyNameProperty, this.deployerPropertyName);
        }
        if (this.deploymentStatus != null) {
            propertyMap.put(deploymentStatusProperty, this.deploymentStatus.getOrdinal());
        }
        if (!propertyMap.isEmpty()) {
            propertyMap = null;
        }
        return propertyMap;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getDeployer() {
        return this.deployer;
    }

    public void setDeployer(String deployer) {
        this.deployer = deployer;
    }

    public String getDeployerTypeName() {
        return this.deployerTypeName;
    }

    public void setDeployerTypeName(String deployerTypeName) {
        this.deployerTypeName = deployerTypeName;
    }

    public String getDeployerPropertyName() {
        return this.deployerPropertyName;
    }

    public void setDeployerPropertyName(String deployerPropertyName) {
        this.deployerPropertyName = deployerPropertyName;
    }

    public OperationalStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void setDeploymentStatus(OperationalStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    @Override
    public String toString() {
        return "DeploymentProperties{deploymentTime=" + this.deploymentTime + ", deployer='" + this.deployer + "', deploymentStatus=" + this.deploymentStatus + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DeploymentProperties that = (DeploymentProperties)objectToCompare;
        return Objects.equals(this.deploymentTime, that.deploymentTime) && Objects.equals(this.deployer, that.deployer) && Objects.equals(this.deployerTypeName, that.deployerTypeName) && Objects.equals(this.deployerPropertyName, that.deployerPropertyName) && this.deploymentStatus == that.deploymentStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deploymentTime, this.deployer, this.deployerTypeName, this.deployerPropertyName, this.deploymentStatus);
    }
}

