/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalColumnMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalSchemaMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalTableMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum SurveyDatabaseAnnotationType implements AnnotationType
{
    SCHEMA_LIST("Capture List of Schemas", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible schema in the surveyed resource.", "Schemas listed include their catalog name and schema name.  If schemas are missing, check the security permissions of the survey service's userId.", SurveyDatabaseAnnotationType.getProfilePropertiesPropertyName(), null),
    TABLE_LIST("Capture List of Tables", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible tables in the surveyed Unity Catalog (UC) resource (server, catalog or schema).", "Tables listed include their catalog name, schema name and table name.  If tables are missing, check the security permissions of the survey service's userId.", SurveyDatabaseAnnotationType.getProfilePropertiesPropertyName(), null),
    COLUMN_LIST("Capture List of Table Columns", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible columns within the tables in the surveyed resource.", "Tables listed include their catalog name, schema name and table name.  If tables are missing, check the security permissions of the survey service's userId.", SurveyDatabaseAnnotationType.getProfilePropertiesPropertyName(), null),
    DATABASE_TABLE_SIZES("Capture Database Table Sizes", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the sizes of the visible tables in a database.", "Tables listed include their database name and schema name.  If tables are missing, check the security permissions of the survey service's database userId.", null, null),
    DATABASE_SCHEMA_TABLE_SIZES("Capture Table Sizes for a Database Schema", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the sizes of the visible tables in a database schema.", "Tables listed include their database name and schema name.  If tables are missing, check the security permissions of the survey service's database userId.", null, null),
    DATABASE_MEASUREMENTS("Capture Database Measurements", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a database.", "This annotation retrieves statistics about a database and its usage.", null, RelationalDatabaseMetric.getMetrics()),
    SCHEMA_MEASUREMENTS("Capture Database Schema Measurements", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about the database tables in a database schema.", "This annotation retrieves statistics about individual tables and columns, and aggregates them into a summary for the schema.", null, RelationalSchemaMetric.getMetrics()),
    TABLE_MEASUREMENTS("Capture Database Table Measurements", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a database table.", "This annotation retrieves statistics about individual columns and aggregates them into a summary for the table.", null, RelationalTableMetric.getMetrics()),
    COLUMN_MEASUREMENTS("Capture Database Column Measurements", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about a database column.", "This annotation retrieves statistics about an individual column.", null, RelationalColumnMetric.getMetrics()),
    COLUMN_VALUES("Capture Frequent Values for Column", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Capture the most common values stored in the column and their frequencies.", "This annotation extracts the statistics maintained by the database.", null, null);

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final List<String> profilePropertyNames;
    public final List<SurveyMetric> metrics;

    private SurveyDatabaseAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, List<String> profilePropertyNames, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.profilePropertyNames = profilePropertyNames;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getPostgresServerAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(DATABASE_MEASUREMENTS.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    public static List<AnnotationTypeType> getPostgresDatabaseAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (SurveyDatabaseAnnotationType surveyDatabaseAnnotationType : SurveyDatabaseAnnotationType.values()) {
            annotationTypeTypes.add(surveyDatabaseAnnotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    private static List<String> getProfilePropertiesPropertyName() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
        return propertyNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAnalysisStep() {
        return AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName();
    }

    @Override
    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public String getExpression() {
        return null;
    }

    public List<String> getProfilePropertyNames() {
        return this.profilePropertyNames;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric relationalDatabaseMetric : this.metrics) {
                metricsMap.put(relationalDatabaseMetric.getDisplayName(), relationalDatabaseMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "SurveyDatabaseAnnotationType{ name='" + this.name + "}";
    }
}

