/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.converters;

import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SurveyReport;

public class SurveyReportConverter<B>
extends OpenMetadataConverterBase<B> {
    public SurveyReportConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public SurveyReport getSurveyReport(Class<B> beanClass, OpenMetadataElement primaryElement, RelatedMetadataElementList relationships, String methodName) throws PropertyServerException {
        if (this.propertyHelper.isTypeOf(primaryElement, OpenMetadataType.SURVEY_REPORT.typeName)) {
            SurveyReport surveyReport = new SurveyReport();
            surveyReport.setElementHeader(this.getMetadataElementHeader(beanClass, primaryElement, methodName));
            ElementProperties elementProperties = null;
            if (primaryElement.getElementProperties() != null) {
                elementProperties = new ElementProperties(primaryElement.getElementProperties());
            }
            surveyReport.setQualifiedName(super.removeQualifiedName(elementProperties));
            surveyReport.setDisplayName(super.removeDisplayName(elementProperties));
            surveyReport.setDescription(super.removeDescription(elementProperties));
            surveyReport.setPurpose(super.removePurpose(elementProperties));
            surveyReport.setUser(super.removeUser(elementProperties));
            surveyReport.setAnalysisParameters(super.removeAnalysisParameters(elementProperties));
            surveyReport.setAssetGUID(super.removeAssetGUID(elementProperties));
            surveyReport.setAnalysisStep(super.removeAnalysisStep(elementProperties));
            surveyReport.setStartDate(super.removeStartDate(elementProperties));
            surveyReport.setCompletionDate(super.removeCompletionDate(elementProperties));
            surveyReport.setCompletionMessage(super.removeCompletionMessage(elementProperties));
            surveyReport.setAdditionalProperties(super.removeAdditionalProperties(elementProperties));
            surveyReport.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
            if (relationships != null && relationships.getElementList() != null) {
                for (RelatedMetadataElement relationship : relationships.getElementList()) {
                    if (relationship == null || !this.propertyHelper.isTypeOf(relationship, OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeName)) continue;
                    surveyReport.setEngineActionGUID(relationship.getElement().getElementGUID());
                    break;
                }
            }
        }
        return null;
    }
}

