/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalSchemaMetric implements SurveyMetric
{
    TOTAL_TABLE_SIZE("totalTableSize", "long", "Total size of tables", "Sum of the sizes (in bytes) of the tables in the schema."),
    TABLE_COUNT("tableCount", "long", "Number of tables", "Count of tables in the schema."),
    VIEW_COUNT("viewCount", "long", "Number of views", "Count of views in the schema."),
    COLUMN_COUNT("columnCount", "long", "Number of columns", "Count of all columns in the table/views."),
    MAT_VIEW_COUNT("materializedViewCount", "long", "Number of materialized views", "Count of materialized views in the database/schema.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalSchemaMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(RelationalDatabaseMetric.values()));
    }

    public String toString() {
        return "RelationalSchemaMetric{" + this.displayName + "}";
    }
}

