/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Classification
extends InstanceAuditHeader {
    private static final long serialVersionUID = 1L;
    private String classificationName = null;
    private InstanceProperties classificationProperties = null;
    private ClassificationOrigin classificationOrigin = ClassificationOrigin.ASSIGNED;
    private String classificationOriginGUID = null;

    private String validateName(String name) {
        if (name == null || name.equals("")) {
            String methodName = "validateName";
            throw new OMRSRuntimeException(OMRSErrorCode.NULL_CLASSIFICATION_PROPERTY_NAME.getMessageDefinition(), this.getClass().getName(), "validateName");
        }
        return name;
    }

    public Classification() {
    }

    public Classification(Classification template) {
        super(template);
        if (template == null) {
            String methodName = "Copy Constructor";
            throw new OMRSRuntimeException(OMRSErrorCode.NULL_CLASSIFICATION_PROPERTY_NAME.getMessageDefinition("<Unknown>"), this.getClass().getName(), "Copy Constructor");
        }
        this.classificationName = this.validateName(template.getName());
        this.classificationProperties = template.getProperties();
        this.classificationOrigin = template.getClassificationOrigin();
        this.classificationOriginGUID = template.getClassificationOriginGUID();
    }

    public String getName() {
        return this.classificationName;
    }

    public void setName(String classificationName) {
        this.classificationName = this.validateName(classificationName);
    }

    public InstanceProperties getProperties() {
        if (this.classificationProperties == null) {
            return null;
        }
        if (this.classificationProperties.getInstanceProperties() == null && this.classificationProperties.getEffectiveFromTime() == null && this.classificationProperties.getEffectiveToTime() == null) {
            return null;
        }
        return new InstanceProperties(this.classificationProperties);
    }

    public void setProperties(InstanceProperties classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public ClassificationOrigin getClassificationOrigin() {
        return this.classificationOrigin;
    }

    public void setClassificationOrigin(ClassificationOrigin classificationOrigin) {
        this.classificationOrigin = classificationOrigin;
    }

    public String getClassificationOriginGUID() {
        return this.classificationOriginGUID;
    }

    public void setClassificationOriginGUID(String classificationOriginGUID) {
        this.classificationOriginGUID = classificationOriginGUID;
    }

    @Override
    public String toString() {
        return "Classification{classificationName='" + this.classificationName + "', classificationProperties=" + this.classificationProperties + ", classificationOrigin=" + this.classificationOrigin + ", classificationOriginGUID='" + this.classificationOriginGUID + "', name='" + this.getName() + "', properties=" + this.getProperties() + ", headerVersion=" + this.getHeaderVersion() + ", type=" + this.getType() + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + "', metadataCollectionName='" + this.getMetadataCollectionName() + "', replicatedBy='" + this.getReplicatedBy() + "', instanceLicense='" + this.getInstanceLicense() + "', status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + "', updatedBy='" + this.getUpdatedBy() + "', maintainedBy=" + this.getMaintainedBy() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + ", mappingProperties=" + this.getMappingProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Classification that = (Classification)objectToCompare;
        return Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.classificationProperties, that.classificationProperties) && this.getClassificationOrigin() == that.getClassificationOrigin() && Objects.equals(this.getClassificationOriginGUID(), that.getClassificationOriginGUID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationName, this.classificationProperties, this.getClassificationOrigin(), this.getClassificationOriginGUID());
    }
}

