/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;

public abstract class OMRSRepositoryEventMapperConnector
extends ConnectorBase
implements OMRSRepositoryEventMapper,
AuditLoggingComponent {
    protected OMRSRepositoryEventProcessor repositoryEventProcessor = null;
    protected String repositoryEventMapperName = null;
    protected OMRSRepositoryConnector repositoryConnector = null;
    protected OMRSRepositoryHelper repositoryHelper = null;
    protected OMRSRepositoryValidator repositoryValidator = null;
    protected String localMetadataCollectionId = null;
    protected String localServerName = null;
    protected String localServerType = null;
    protected String localOrganizationName = null;
    protected String localServerUserId = null;
    protected AuditLog auditLog = null;
    private List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();

    OMRSRepositoryEventMapperConnector() {
    }

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void initialize(String repositoryEventMapperName, OMRSRepositoryConnector repositoryConnector) {
        this.repositoryEventMapperName = repositoryEventMapperName;
        this.repositoryConnector = repositoryConnector;
    }

    @Override
    public void setRepositoryHelper(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    @Override
    public void setRepositoryValidator(OMRSRepositoryValidator repositoryValidator) {
        this.repositoryValidator = repositoryValidator;
    }

    @Override
    public void setServerName(String serverName) {
        this.localServerName = serverName;
    }

    @Override
    public void setServerType(String serverType) {
        this.localServerType = serverType;
    }

    @Override
    public void setOrganizationName(String organizationName) {
        this.localOrganizationName = organizationName;
    }

    @Override
    public void setServerUserId(String localServerUserId) {
        this.localServerUserId = localServerUserId;
    }

    @Override
    public void setMetadataCollectionId(String metadataCollectionId) {
        this.localMetadataCollectionId = metadataCollectionId;
    }

    @Override
    public void setRepositoryEventProcessor(OMRSRepositoryEventProcessor repositoryEventProcessor) {
        this.repositoryEventProcessor = repositoryEventProcessor;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "Start Event Mapper";
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("Start Event Mapper", OMRSAuditCode.EVENT_MAPPER_LISTENER_STARTED.getMessageDefinition(this.repositoryEventMapperName), this.getConnection().toString());
        }
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        String methodName = "Disconnect Event Mapper";
        super.disconnect();
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.disconnect();
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("Disconnect Event Mapper", OMRSAuditCode.EVENT_MAPPER_LISTENER_DISCONNECTED.getMessageDefinition(this.repositoryEventMapperName), this.getConnection().toString());
        }
    }
}

