/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public class ServerHttpResponseDecorator
implements ServerHttpResponse {
    private final ServerHttpResponse delegate;

    public ServerHttpResponseDecorator(ServerHttpResponse delegate) {
        Assert.notNull((Object)delegate, "Delegate is required");
        this.delegate = delegate;
    }

    public ServerHttpResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean setStatusCode(@Nullable HttpStatusCode status) {
        return this.getDelegate().setStatusCode(status);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.getDelegate().getStatusCode();
    }

    @Override
    public boolean setRawStatusCode(@Nullable Integer value) {
        return this.getDelegate().setRawStatusCode(value);
    }

    @Override
    @Deprecated
    public Integer getRawStatusCode() {
        return this.getDelegate().getRawStatusCode();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getDelegate().getHeaders();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.getDelegate().getCookies();
    }

    @Override
    public void addCookie(ResponseCookie cookie) {
        this.getDelegate().addCookie(cookie);
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.getDelegate().bufferFactory();
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        this.getDelegate().beforeCommit(action);
    }

    @Override
    public boolean isCommitted() {
        return this.getDelegate().isCommitted();
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.getDelegate().writeWith(body);
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.getDelegate().writeAndFlushWith(body);
    }

    @Override
    public Mono<Void> setComplete() {
        return this.getDelegate().setComplete();
    }

    public static <T> T getNativeResponse(ServerHttpResponse response) {
        if (response instanceof AbstractServerHttpResponse) {
            AbstractServerHttpResponse abstractServerHttpResponse = (AbstractServerHttpResponse)response;
            return abstractServerHttpResponse.getNativeResponse();
        }
        if (response instanceof ServerHttpResponseDecorator) {
            ServerHttpResponseDecorator serverHttpResponseDecorator = (ServerHttpResponseDecorator)response;
            return ServerHttpResponseDecorator.getNativeResponse(serverHttpResponseDecorator.getDelegate());
        }
        throw new IllegalArgumentException("Can't find native response in " + response.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegate=" + this.getDelegate() + "]";
    }
}

