/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports.surveyreport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.reports.EgeriaReport;

public class SurveyReport {
    private final String serverName;
    private final String platformURLRoot;
    private final String clientUserId;
    private final String assetGUID;
    private final String reportFileName;
    private final Date reportDate = new Date();

    private SurveyReport(String serverName, String platformURLRoot, String clientUserId, String assetGUID) {
        this.serverName = serverName;
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
        this.assetGUID = assetGUID;
        this.reportFileName = "survey-report-for-asset-" + assetGUID + "-" + this.reportDate + ".md";
    }

    private String getReportLinkURI(Date creationTime) {
        String noSpaces = creationTime.toString().replace(' ', 'x');
        String noColons = noSpaces.replaceAll("[^a-zA-Z0-9]", "");
        return "#survey-report-" + noColons.replace('x', '-');
    }

    public String getAnnotationTitle(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        String annotationTitle = annotationElement.getType().getTypeName() + ": GUID " + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            annotationTitle = annotationElement.getType().getTypeName() + ": " + (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
        }
        return annotationTitle;
    }

    public String getAnnotationURL(OpenMetadataElement annotationElement) {
        Map annotationProperties;
        String annotationURL = "#" + annotationElement.getType().getTypeName() + "-GUID-" + annotationElement.getElementGUID();
        if (annotationElement.getElementProperties() != null && (annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings()).get(OpenMetadataProperty.ANNOTATION_TYPE.name) != null) {
            String annotationType = (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name);
            annotationURL = "#" + annotationElement.getType().getTypeName() + "-" + annotationType.replace(' ', '-');
        }
        return annotationURL;
    }

    private void printReport(int reportIndentLevel, OpenMetadataStoreClient openMetadataStoreClient, RelatedMetadataElement surveyReportLinkElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Map surveyReportProperties;
        int annotationIndentLevel = reportIndentLevel + 1;
        OpenMetadataElement surveyReportElement = surveyReportLinkElement.getElement();
        outputReport.printReportSubheading(reportIndentLevel, "Survey report: " + surveyReportElement.getVersions().getCreateTime());
        if (surveyReportElement.getElementProperties() != null && (surveyReportProperties = surveyReportElement.getElementProperties().getPropertiesAsStrings()) != null) {
            for (String propertyName : surveyReportProperties.keySet()) {
                outputReport.printReportLine(reportIndentLevel, propertyName, (String)surveyReportProperties.get(propertyName));
            }
        }
        outputReport.printReportLine(reportIndentLevel, "\n**Annotations**");
        int startFrom = 0;
        int maxPageSize = 100;
        RelatedMetadataElementList annotationElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, surveyReportLinkElement.getElement().getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom, maxPageSize);
        if (annotationElements != null && annotationElements.getElementList() != null) {
            while (annotationElements != null && annotationElements.getElementList() != null) {
                for (RelatedMetadataElement reportedAnnotationLink : annotationElements.getElementList()) {
                    if (reportedAnnotationLink == null || reportedAnnotationLink.getElement() == null) continue;
                    OpenMetadataElement reportedAnnotationElement = reportedAnnotationLink.getElement();
                    outputReport.printReportLine(reportIndentLevel, "* [" + this.getAnnotationTitle(reportedAnnotationElement) + "](" + this.getAnnotationURL(reportedAnnotationElement) + ")");
                }
                annotationElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, surveyReportLinkElement.getElement().getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom += maxPageSize, maxPageSize);
            }
        } else {
            outputReport.printReportLine(annotationIndentLevel, "\nNone.");
        }
        startFrom = 0;
        annotationElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, surveyReportLinkElement.getElement().getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom, maxPageSize);
        while (annotationElements != null && annotationElements.getElementList() != null) {
            for (RelatedMetadataElement reportedAnnotationElement : annotationElements.getElementList()) {
                if (reportedAnnotationElement == null || reportedAnnotationElement.getElement() == null) continue;
                this.printAnnotation(annotationIndentLevel, openMetadataStoreClient, reportedAnnotationElement, outputReport);
            }
            annotationElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, surveyReportLinkElement.getElement().getElementGUID(), 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void printMapProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            MapTypePropertyValue mapTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Name", "Value"));
            outputReport.printReportLine(indentLevel, "* **" + propertyName + "**:");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof MapTypePropertyValue && (mapTypePropertyValue = (MapTypePropertyValue)propertyValue).getMapValues() != null) {
                Map mapValueProperties = mapTypePropertyValue.getMapValues().getPropertiesAsStrings();
                for (String mapPropertyName : mapValueProperties.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Arrays.asList(mapPropertyName, (String)mapValueProperties.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printArrayProperty(int indentLevel, String propertyName, ElementProperties elementProperties, EgeriaReport outputReport) throws IOException {
        int annotationPropertyIndentLevel = indentLevel + 1;
        if (elementProperties != null && elementProperties.getPropertyValue(propertyName) != null) {
            ArrayTypePropertyValue arrayTypePropertyValue;
            ArrayList<String> tableHeadings = new ArrayList<String>(List.of("Values"));
            outputReport.printReportLine(indentLevel, "* **" + propertyName + "**:");
            PropertyValue propertyValue = elementProperties.getPropertyValue(propertyName);
            if (propertyValue instanceof ArrayTypePropertyValue && (arrayTypePropertyValue = (ArrayTypePropertyValue)propertyValue).getArrayValues() != null) {
                Map propertiesAsStrings = arrayTypePropertyValue.getArrayValues().getPropertiesAsStrings();
                for (String mapPropertyName : propertiesAsStrings.keySet()) {
                    outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Collections.singletonList((String)propertiesAsStrings.get(mapPropertyName))));
                    tableHeadings = null;
                }
            }
        }
    }

    private void printAnnotation(int annotationIndentLevel, OpenMetadataStoreClient openMetadataStoreClient, RelatedMetadataElement reportedAnnotationElement, EgeriaReport outputReport) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int annotationPropertyIndentLevel = annotationIndentLevel + 1;
        int startFrom = 0;
        int maxPageSize = 100;
        ArrayList<String> tableHeadings = new ArrayList<String>(Arrays.asList("Property Name", "Property Value"));
        OpenMetadataElement annotationElement = reportedAnnotationElement.getElement();
        outputReport.printReportSubheading(annotationIndentLevel, this.getAnnotationTitle(annotationElement));
        outputReport.printReportLine(annotationIndentLevel, "Creation Time", annotationElement.getVersions().getCreateTime().toString());
        if (annotationElement.getElementProperties() != null) {
            ArrayList<String> processedProperties = new ArrayList<String>();
            Map annotationProperties = annotationElement.getElementProperties().getPropertiesAsStrings();
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANNOTATION_TYPE.name, (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_TYPE.name));
            processedProperties.add(OpenMetadataProperty.ANNOTATION_TYPE.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.SUMMARY.name, (String)annotationProperties.get(OpenMetadataProperty.SUMMARY.name));
            processedProperties.add(OpenMetadataProperty.SUMMARY.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANNOTATION_STATUS.name, (String)annotationProperties.get(OpenMetadataProperty.ANNOTATION_STATUS.name));
            processedProperties.add(OpenMetadataProperty.ANNOTATION_STATUS.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.CONFIDENCE_LEVEL.name, (String)annotationProperties.get(OpenMetadataProperty.CONFIDENCE_LEVEL.name));
            processedProperties.add(OpenMetadataProperty.CONFIDENCE_LEVEL.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPRESSION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPRESSION.name));
            processedProperties.add(OpenMetadataProperty.EXPRESSION.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.EXPLANATION.name, (String)annotationProperties.get(OpenMetadataProperty.EXPLANATION.name));
            processedProperties.add(OpenMetadataProperty.EXPLANATION.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.ANALYSIS_STEP.name, (String)annotationProperties.get(OpenMetadataProperty.ANALYSIS_STEP.name));
            processedProperties.add(OpenMetadataProperty.ANALYSIS_STEP.name);
            outputReport.printReportLine(annotationIndentLevel, OpenMetadataProperty.JSON_PROPERTIES.name, (String)annotationProperties.get(OpenMetadataProperty.JSON_PROPERTIES.name));
            processedProperties.add(OpenMetadataProperty.JSON_PROPERTIES.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_COUNT.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.VALUE_COUNT.name);
            this.printArrayProperty(annotationIndentLevel, OpenMetadataProperty.VALUE_LIST.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.VALUE_COUNT.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.PROFILE_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
            this.printMapProperty(annotationIndentLevel, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, annotationElement.getElementProperties(), outputReport);
            processedProperties.add(OpenMetadataProperty.ADDITIONAL_PROPERTIES.name);
            outputReport.printReportLine(annotationIndentLevel, "* **Other Properties**:");
            for (String propertyName : annotationProperties.keySet()) {
                if (processedProperties.contains(propertyName)) continue;
                outputReport.printElementInTable(annotationPropertyIndentLevel, tableHeadings, new ArrayList<String>(Arrays.asList(propertyName, (String)annotationProperties.get(propertyName))));
                tableHeadings = null;
            }
        }
        RelatedMetadataElementList associatedElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom, maxPageSize);
        while (associatedElements != null && associatedElements.getElementList() != null) {
            int associatedElementIndentLevel = annotationIndentLevel + 1;
            for (RelatedMetadataElement associatedElement : associatedElements.getElementList()) {
                if (associatedElement == null) continue;
                outputReport.printReportLine(associatedElementIndentLevel, "Associated " + associatedElement.getElement().getType().getTypeName() + " Element: " + associatedElement.getElement().getElementGUID());
                if (associatedElement.getElement().getElementProperties() == null) continue;
                Map associatedElementProperties = associatedElement.getElement().getElementProperties().getPropertiesAsStrings();
                for (String propertyName : associatedElementProperties.keySet()) {
                    outputReport.printReportLine(associatedElementIndentLevel + 1, propertyName, (String)associatedElementProperties.get(propertyName));
                }
            }
            associatedElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, reportedAnnotationElement.getElement().getElementGUID(), 2, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, startFrom += maxPageSize, maxPageSize);
        }
    }

    private void run() {
        int indentLevel = 0;
        try {
            OpenMetadataStoreClient openMetadataStoreClient = new OpenMetadataStoreClient(this.serverName, this.platformURLRoot, 100);
            AssetOwner assetOwnerClient = new AssetOwner(this.serverName, this.platformURLRoot);
            AssetElement asset = assetOwnerClient.getAssetSummary(this.clientUserId, this.assetGUID);
            if (asset != null) {
                EgeriaReport outputReport = new EgeriaReport(this.reportFileName);
                outputReport.printReportTitle(indentLevel, "Asset survey report");
                outputReport.printReportLine(indentLevel, "Date: " + this.reportDate);
                int detailIndentLevel = indentLevel + 1;
                outputReport.printReportSubheading(detailIndentLevel, "Asset summary");
                outputReport.printReportLine(detailIndentLevel, "Unique identifier", this.assetGUID);
                outputReport.printReportLine(detailIndentLevel, "Type", asset.getElementHeader().getType().getTypeName());
                if (asset.getProperties().getExtendedProperties() != null && asset.getProperties().getExtendedProperties().get(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name) != null) {
                    outputReport.printReportLine(detailIndentLevel, "Deployed Implementation Type", asset.getProperties().getExtendedProperties().get(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name).toString());
                }
                outputReport.printReportLine(detailIndentLevel, "Qualified Name", asset.getProperties().getQualifiedName());
                outputReport.printReportLine(detailIndentLevel, "Display Name", asset.getProperties().getName());
                outputReport.printReportLine(detailIndentLevel, "Description", asset.getProperties().getResourceDescription());
                outputReport.printReportSubheading(detailIndentLevel, "Survey report summaries");
                RelatedMetadataElementList surveyReportElements = openMetadataStoreClient.getRelatedMetadataElements(this.clientUserId, this.assetGUID, 1, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, this.reportDate, 0, 0);
                if (surveyReportElements != null && surveyReportElements.getElementList() != null) {
                    int reportIndentLevel = detailIndentLevel + 1;
                    for (RelatedMetadataElement surveyReportElement : surveyReportElements.getElementList()) {
                        if (surveyReportElement == null) continue;
                        outputReport.printReportLine(reportIndentLevel, "* [" + surveyReportElement.getVersions().getCreateTime() + "](" + this.getReportLinkURI(surveyReportElement.getVersions().getCreateTime()) + ")");
                    }
                    for (RelatedMetadataElement surveyReportElement : surveyReportElements.getElementList()) {
                        if (surveyReportElement == null) continue;
                        this.printReport(reportIndentLevel, openMetadataStoreClient, surveyReportElement, outputReport);
                    }
                }
                outputReport.closeReport();
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String serverName = "active-metadata-store";
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "erinoverview";
        String assetGUID = null;
        if (args.length > 0) {
            assetGUID = args[0];
        } else {
            System.out.println("Please provide the unique identifier (guid) in the first parameter.  Other parameters are optional.\n");
            System.out.println("    SurveyReport <assetGUID> <platformURLRoot> <clientUserId> <serverName>");
            System.exit(-1);
        }
        if (args.length > 1) {
            platformURLRoot = args[1];
        }
        if (args.length > 2) {
            clientUserId = args[2];
        }
        if (args.length > 3) {
            serverName = args[3];
        }
        System.out.println("===============================");
        System.out.println("Survey Report for asset:    " + assetGUID);
        System.out.println("===============================");
        System.out.println("Running against platform: " + platformURLRoot);
        System.out.println("Focused on server: " + serverName);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            SurveyReport report = new SurveyReport(serverName, platformURLRoot, clientUserId, assetGUID);
            report.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

