/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetCertificationInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerBaseClient;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CertificationTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CertificationTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationProperties;

public class AssetCertificationManager
extends AssetOwnerBaseClient
implements AssetCertificationInterface {
    public AssetCertificationManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetCertificationManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetCertificationManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public AssetCertificationManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public AssetCertificationManager(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    @Override
    public CertificationTypeElement getCertificationTypeByGUID(String userId, String certificationTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certification-types/{2}";
        String guidParameterName = "certificationTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByGUID");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "getCertificationTypeByGUID");
        CertificationTypeResponse restResult = this.restClient.callCertificationTypeGetRESTCall("getCertificationTypeByGUID", urlTemplate, this.serverName, userId, certificationTypeGUID);
        return restResult.getElement();
    }

    @Override
    public CertificationTypeElement getCertificationTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByDocId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certification-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getCertificationTypeByDocId");
        CertificationTypeResponse restResult = this.restClient.callCertificationTypeGetRESTCall("getCertificationTypeByDocId", urlTemplate, this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    @Override
    public List<CertificationTypeElement> getCertificationTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getCertificationTypesByTitle";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certification-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getCertificationTypesByTitle");
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getCertificationTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCertificationTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        CertificationTypesResponse restResult = this.restClient.callCertificationTypeListPostRESTCall("getCertificationTypesByTitle", urlTemplate, requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    @Override
    public List<CertificationTypeElement> getCertificationTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertificationTypeByDomainId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certification-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "getCertificationTypeByDomainId");
        this.invalidParameterHandler.validateUserId(userId, "getCertificationTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCertificationTypeByDomainId");
        CertificationTypesResponse restResult = this.restClient.callCertificationTypeListGetRESTCall("getCertificationTypeByDomainId", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    @Override
    public String certifyElement(String userId, String elementGUID, String certificationTypeGUID, CertificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "certifyElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/certification-types/{3}/certify";
        String elementGUIDParameterName = "elementGUID";
        String certificationTypeGUIDParameterName = "certificationTypeGUID";
        return super.setupMultiLinkRelationship(userId, elementGUID, "elementGUID", null, properties, certificationTypeGUID, "certificationTypeGUID", urlTemplate, "certifyElement");
    }

    @Override
    public void updateCertification(String userId, String certificationGUID, boolean isMergeUpdate, CertificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateCertification";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certifications/{2}/update?isMergeUpdate={3}";
        String certificationGUIDParameterName = "certificationGUID";
        super.updateRelationship(userId, certificationGUID, "certificationGUID", isMergeUpdate, null, properties, urlTemplate, "updateCertification");
    }

    @Override
    public void decertifyElement(String userId, String certificationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "decertifyElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/certifications/{2}/delete";
        String certificationGUIDParameterName = "certificationGUID";
        super.clearRelationship(userId, certificationGUID, "certificationGUID", null, urlTemplate, "decertifyElement");
    }

    @Override
    public List<RelatedElement> getCertifiedElements(String userId, String certificationTypeGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCertifiedElements";
        String guidParameter = "certificationTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/certifications/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, certificationTypeGUID, "certificationTypeGUID", urlTemplate, startFrom, pageSize, "getCertifiedElements");
    }

    @Override
    public List<RelatedElement> getCertifications(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/certifications?&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicences");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getLicences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicences");
        RelatedElementsResponse restResult = this.restClient.callRelatedElementsGetRESTCall("getLicences", urlTemplate, this.serverName, userId, elementGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

