/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetLicenseInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerBaseClient;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicenseTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LicensesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LicenseElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseProperties;

public class AssetLicenseManager
extends AssetOwnerBaseClient
implements AssetLicenseInterface {
    public AssetLicenseManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetLicenseManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetLicenseManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public AssetLicenseManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public AssetLicenseManager(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    @Override
    public LicenseTypeElement getLicenseTypeByGUID(String userId, String licenseTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/license-types/{2}";
        String guidParameterName = "licenseTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByGUID");
        this.invalidParameterHandler.validateGUID(licenseTypeGUID, "licenseTypeGUID", "getLicenseTypeByGUID");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByGUID", urlTemplate, this.serverName, userId, licenseTypeGUID);
        return restResult.getElement();
    }

    @Override
    public LicenseTypeElement getLicenseTypeByDocId(String userId, String documentIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDocId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/license-types/by-document-id/{2}";
        String documentIdParameterName = "documentId";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDocId");
        this.invalidParameterHandler.validateName(documentIdentifier, "documentId", "getLicenseTypeByDocId");
        LicenseTypeResponse restResult = this.restClient.callLicenseTypeGetRESTCall("getLicenseTypeByDocId", urlTemplate, this.serverName, userId, documentIdentifier);
        return restResult.getElement();
    }

    @Override
    public List<LicenseTypeElement> getLicenseTypesByTitle(String userId, String title, int startFrom, int pageSize) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getLicenseTypesByTitle";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/license-types/by-title?startFrom={2}&pageSize={3}";
        String titleParameterName = "title";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypesByTitle");
        this.invalidParameterHandler.validateSearchString(title, "title", "getLicenseTypesByTitle");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypesByTitle");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(title);
        requestBody.setSearchStringParameterName("title");
        LicenseTypesResponse restResult = this.restClient.callLicenseTypeListPostRESTCall("getLicenseTypesByTitle", urlTemplate, requestBody, this.serverName, userId, startFrom, queryPageSize);
        return restResult.getElements();
    }

    @Override
    public List<LicenseTypeElement> getLicenseTypeByDomainId(String userId, int domainIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicenseTypeByDomainId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/license-types/by-domain/{2}?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicenseTypeByDomainId");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicenseTypeByDomainId");
        LicenseTypesResponse restResult = this.restClient.callLicenseTypesGetRESTCall("getLicenseTypeByDomainId", urlTemplate, this.serverName, userId, domainIdentifier, startFrom, queryPageSize);
        return restResult.getElements();
    }

    @Override
    public String licenseElement(String userId, String elementGUID, String licenseTypeGUID, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "licenseElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/license-types/{3}";
        String elementGUIDParameterName = "elementGUID";
        String licenseTypeGUIDParameterName = "licenseTypeGUID";
        return super.setupMultiLinkRelationship(userId, elementGUID, "elementGUID", null, properties, licenseTypeGUID, "licenseTypeGUID", urlTemplate, "licenseElement");
    }

    @Override
    public void updateLicense(String userId, String licenseGUID, boolean isMergeUpdate, LicenseProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLicense";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/licenses/{2}/update?isMergeUpdate={3}";
        String licenseGUIDParameterName = "licenseGUID";
        super.updateRelationship(userId, licenseGUID, "licenseGUID", isMergeUpdate, null, properties, urlTemplate, "updateLicense");
    }

    @Override
    public void unlicenseElement(String userId, String licenseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlicenseElement";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/licenses/{2}/delete";
        String licenseGUIDParameterName = "licenseGUID";
        super.clearRelationship(userId, licenseGUID, "licenseGUID", null, urlTemplate, "unlicenseElement");
    }

    @Override
    public List<RelatedElement> getLicensedElements(String userId, String licenseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicencedElements";
        String guidParameter = "licenseGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/licenses/{2}?&startFrom={3}&pageSize={4}";
        return super.getRelatedElements(userId, licenseGUID, "licenseGUID", urlTemplate, startFrom, pageSize, "getLicencedElements");
    }

    @Override
    public List<LicenseElement> getLicenses(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLicences";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/licenses?&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getLicences");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getLicences");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLicences");
        LicensesResponse restResult = this.restClient.callLicensesGetRESTCall("getLicences", urlTemplate, this.serverName, userId, elementGUID, startFrom, queryPageSize);
        return restResult.getElements();
    }
}

