/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.spring;

import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.Base64;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.RESTClientConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreCollectionProperty;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStorePurpose;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccount;
import org.odpi.openmetadata.tokenmanager.http.HTTPHeadersThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class SpringRESTClientConnector
extends RESTClientConnector {
    private final RestTemplate restTemplate;
    private String serverName = null;
    private String serverPlatformURLRoot = null;
    private HttpHeaders authorizationHeader = null;
    private Date authorizationHeaderTimeout = null;
    private long refreshTimeInterval = 0L;
    private final MessageFormatter messageFormatter = new MessageFormatter();
    private static final Logger log = LoggerFactory.getLogger(SpringRESTClientConnector.class);

    public SpringRESTClientConnector() throws NoSuchAlgorithmException, KeyManagementException {
        DefaultUriBuilderFactory builderFactory = new DefaultUriBuilderFactory();
        builderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        this.restTemplate = new RestTemplate();
        this.restTemplate.setUriTemplateHandler(builderFactory);
        List<HttpMessageConverter<?>> converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.serverPlatformURLRoot = endpoint.getAddress();
            this.serverName = endpoint.getDisplayName();
        } else {
            log.error("No endpoint for connector.");
            this.serverPlatformURLRoot = null;
            this.serverName = null;
        }
        this.refreshAuthorizationToken();
    }

    private void refreshAuthorizationToken() throws ConnectorCheckedException {
        String userId = this.connectionProperties.getUserId();
        String password = this.connectionProperties.getClearPassword();
        if (this.secretsStoreConnectorMap != null && !this.secretsStoreConnectorMap.isEmpty()) {
            log.debug("Using secrets connector to call server {} on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
            for (String secretsStorePurpose : this.secretsStoreConnectorMap.keySet()) {
                SecretsStoreConnector secretsStoreConnector = (SecretsStoreConnector)this.secretsStoreConnectorMap.get(secretsStorePurpose);
                if (secretsStoreConnector == null) continue;
                this.refreshTimeInterval = secretsStoreConnector.getRefreshTimeInterval();
                if (SecretsStorePurpose.REST_BEARER_TOKEN.getName().equals(secretsStorePurpose)) {
                    String token = secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.TOKEN.getName());
                    if (token == null) continue;
                    this.authorizationHeader = this.createAuthorizationHeaders(token);
                } else if (SecretsStorePurpose.REST_BASIC_AUTHENTICATION.getName().equals(secretsStorePurpose)) {
                    userId = secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.USER_ID.getName());
                    password = secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName());
                    if (userId == null || password == null) continue;
                    this.authorizationHeader = this.createAuthorizationHeaders(userId, password);
                } else {
                    UserAccount userAccount;
                    if (!SecretsStorePurpose.USER_DIRECTORY.getName().equals(secretsStorePurpose) || userId == null || (userAccount = secretsStoreConnector.getUser(userId)) == null || userAccount.getSecrets() == null || userAccount.getSecrets().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()) == null) continue;
                    this.authorizationHeader = this.createAuthorizationHeaders(userId, userAccount.getSecrets().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()));
                }
                break;
            }
        } else if (userId != null && password != null) {
            log.debug("Using basic authentication to call server {} on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
            this.authorizationHeader = this.createAuthorizationHeaders(userId, password);
        } else {
            log.debug("Using no authentication to call server {} on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
        }
        if (this.refreshTimeInterval != 0L) {
            long newRefreshTime = new Date().getTime() + this.refreshTimeInterval * 60L * 1000L;
            this.authorizationHeaderTimeout = new Date(newRefreshTime);
        } else {
            this.authorizationHeaderTimeout = null;
        }
    }

    private HttpHeaders createAuthorizationHeaders(String username, String password) {
        String authorizationString = username + ":" + password;
        byte[] encodedAuthorizationString = Base64.encodeBase64(authorizationString.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuthorizationString);
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authHeader);
        return header;
    }

    private HttpHeaders createAuthorizationHeaders(String token) {
        String authHeader = "Bearer " + token;
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authHeader);
        return header;
    }

    private HttpHeaders getHttpHeaders() throws ConnectorCheckedException {
        HttpHeaders headers = new HttpHeaders();
        Map<String, String> threadLocalHeaders = HTTPHeadersThreadLocal.getHeadersThreadLocal().get();
        if (threadLocalHeaders != null) {
            for (Map.Entry<String, String> entry : threadLocalHeaders.entrySet()) {
                headers.set(entry.getKey(), entry.getValue());
            }
        }
        if (this.authorizationHeaderTimeout != null && new Date().after(this.authorizationHeaderTimeout)) {
            this.refreshAuthorizationToken();
        }
        if (this.authorizationHeader != null) {
            headers.addAll(this.authorizationHeader);
        }
        return headers;
    }

    @Override
    public <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws RESTServerException {
        try {
            T responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, new Object[0]);
            } else {
                HttpEntity request = new HttpEntity(headers);
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            T responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, params);
            } else {
                HttpEntity request = new HttpEntity(headers);
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            T responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, new Object[0]);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            T responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpHeaders httpHeaders;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request = (httpHeaders = this.getHttpHeaders()) == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders), returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPutRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            HttpHeaders httpHeaders = this.getHttpHeaders();
            HttpEntity<Object> request = httpHeaders == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders);
            ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, returnClass, new Object[0]);
            Object responseObject = responseEntity.getBody();
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            T responseObject = null;
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                this.restTemplate.delete(urlTemplate, new Object[0]);
            } else {
                HttpEntity<Object> request;
                if (requestBody != null) {
                    request = new HttpEntity<Object>(requestBody, headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity(headers);
                }
                ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, (Object)responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpHeaders httpHeaders;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request = (httpHeaders = this.getHttpHeaders()) == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders), returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    @Override
    public <T> T callPatchRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpHeaders httpHeaders;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PATCH, request = (httpHeaders = this.getHttpHeaders()) == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders), returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpEntity<Object> request;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                request = new HttpEntity<Object>(requestBody);
            } else if (requestBody != null) {
                request = new HttpEntity<Object>(requestBody, headers);
            } else {
                log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                request = new HttpEntity(headers);
            }
            ResponseEntity<T> responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, responseType, params);
            Object responseObject = responseEntity.getBody();
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            HttpHeaders headers;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request = (headers = this.getHttpHeaders()).isEmpty() ? HttpEntity.EMPTY : new HttpEntity(headers), responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpHeaders httpHeaders;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request = (httpHeaders = this.getHttpHeaders()) == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders), responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpHeaders httpHeaders;
            HttpEntity<Object> request;
            ResponseEntity<T> responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", methodName, urlTemplate, Arrays.toString(params));
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request = (httpHeaders = this.getHttpHeaders()) == null ? new HttpEntity<Object>(requestBody) : new HttpEntity<Object>(requestBody, httpHeaders), responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", error.getClass().getName(), error.getMessage(), methodName);
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage());
            String errorMessage = this.messageFormatter.getFormattedMessage(messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }
}

