/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RepositoryServicesConfig
extends AdminServicesConfigHeader {
    private List<Connection> auditLogConnections = new ArrayList<Connection>();
    private List<Connection> openMetadataArchiveConnections = new ArrayList<Connection>();
    private LocalRepositoryConfig localRepositoryConfig = null;
    private EnterpriseAccessConfig enterpriseAccessConfig = null;
    private List<CohortConfig> cohortConfigList = new ArrayList<CohortConfig>();

    public RepositoryServicesConfig() {
    }

    public RepositoryServicesConfig(RepositoryServicesConfig template) {
        if (template != null) {
            this.auditLogConnections = template.getAuditLogConnections();
            this.openMetadataArchiveConnections = template.getOpenMetadataArchiveConnections();
            this.localRepositoryConfig = template.getLocalRepositoryConfig();
            this.enterpriseAccessConfig = template.getEnterpriseAccessConfig();
            this.cohortConfigList = template.getCohortConfigList();
        }
    }

    public List<Connection> getAuditLogConnections() {
        if (this.auditLogConnections == null) {
            return null;
        }
        if (this.auditLogConnections.isEmpty()) {
            return null;
        }
        return this.auditLogConnections;
    }

    public void setAuditLogConnections(List<Connection> auditLogConnections) {
        this.auditLogConnections = auditLogConnections;
    }

    public List<Connection> getOpenMetadataArchiveConnections() {
        if (this.openMetadataArchiveConnections == null) {
            return null;
        }
        if (this.openMetadataArchiveConnections.isEmpty()) {
            return null;
        }
        return this.openMetadataArchiveConnections;
    }

    public void setOpenMetadataArchiveConnections(List<Connection> openMetadataArchiveConnections) {
        this.openMetadataArchiveConnections = openMetadataArchiveConnections;
    }

    public LocalRepositoryConfig getLocalRepositoryConfig() {
        return this.localRepositoryConfig;
    }

    public void setLocalRepositoryConfig(LocalRepositoryConfig localRepositoryConfig) {
        this.localRepositoryConfig = localRepositoryConfig;
    }

    public EnterpriseAccessConfig getEnterpriseAccessConfig() {
        return this.enterpriseAccessConfig;
    }

    public void setEnterpriseAccessConfig(EnterpriseAccessConfig enterpriseAccessConfig) {
        this.enterpriseAccessConfig = enterpriseAccessConfig;
    }

    public List<CohortConfig> getCohortConfigList() {
        if (this.cohortConfigList == null) {
            return null;
        }
        if (this.cohortConfigList.isEmpty()) {
            return null;
        }
        return this.cohortConfigList;
    }

    public void setCohortConfigList(List<CohortConfig> cohortConfigList) {
        this.cohortConfigList = cohortConfigList;
    }

    public String toString() {
        return "RepositoryServicesConfig{auditLogConnections=" + this.auditLogConnections + ", openMetadataArchiveConnections=" + this.openMetadataArchiveConnections + ", localRepositoryConfig=" + this.localRepositoryConfig + ", enterpriseAccessConfig=" + this.enterpriseAccessConfig + ", cohortConfigList=" + this.cohortConfigList + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RepositoryServicesConfig that = (RepositoryServicesConfig)objectToCompare;
        return Objects.equals(this.getAuditLogConnections(), that.getAuditLogConnections()) && Objects.equals(this.getOpenMetadataArchiveConnections(), that.getOpenMetadataArchiveConnections()) && Objects.equals(this.getLocalRepositoryConfig(), that.getLocalRepositoryConfig()) && Objects.equals(this.getEnterpriseAccessConfig(), that.getEnterpriseAccessConfig()) && Objects.equals(this.getCohortConfigList(), that.getCohortConfigList());
    }

    public int hashCode() {
        return Objects.hash(this.getAuditLogConnections(), this.getOpenMetadataArchiveConnections(), this.getLocalRepositoryConfig(), this.getEnterpriseAccessConfig(), this.getCohortConfigList());
    }
}

