/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnector;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonAuditCode;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.springframework.core.ParameterizedTypeReference;

public class FFDCRESTClientBase {
    protected String serverName;
    protected String serverPlatformURLRoot;
    protected AuditLog auditLog = null;
    protected final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final RESTClientConnector clientConnector;

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "RESTClient(no authentication)";
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(serverName, error.getMessage()), this.getClass().getName(), "RESTClient(no authentication)", (Throwable)error, "serverPlatformURLRoot or serverName");
        }
    }

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        this(serverName, serverPlatformURLRoot, null);
    }

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password, null, auditLog);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OMAGCommonErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(serverName, error.getMessage()), this.getClass().getName(), "RESTClient(userId and password)", (Throwable)error, "serverPlatformURLRoot or serverName");
        }
    }

    protected FFDCRESTClientBase(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        this(serverName, serverPlatformURLRoot, userId, password, null);
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    public <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return clientConnector.callPostRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return clientConnector.callPutRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return clientConnector.callDeleteRESTCall(methodName, responseType, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, Exception error) throws PropertyServerException {
        if (this.auditLog != null) {
            this.auditLog.logException(methodName, OMAGCommonAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.serverPlatformURLRoot, error.getMessage()), error);
        }
        throw new PropertyServerException(OMAGCommonErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.serverPlatformURLRoot, error.getMessage()), this.getClass().getName(), methodName, error);
    }
}

