/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum AuditLogRecordSeverityLevel implements AuditLogRecordSeverity
{
    UNKNOWN(0, "Unknown", "Uninitialized Severity."),
    INFO(1, "Information", "The server is providing information about its normal operation."),
    EVENT(2, "Event", "An event was sent to or received from another participant in the server's ecosystem."),
    DECISION(3, "Decision", "A decision has been made related to the operation of the system."),
    ACTION(4, "Action", "Action is required by the administrator.  At a minimum, the situation needs to be investigated and if necessary, corrective action taken."),
    ERROR(5, "Error", "An error occurred. This may restrict some of the server's operations."),
    EXCEPTION(6, "Exception", "An unexpected exception occurred.  Details of the exception and stack trace are included in the log record."),
    SECURITY(7, "Security", "Unauthorized access to a service or metadata instance has been attempted."),
    STARTUP(8, "Startup", "A new component is starting up."),
    SHUTDOWN(9, "Shutdown", "An existing component is shutting down."),
    ASSET(10, "Asset", "An auditable action relating to an asset has been taken."),
    TYPES(11, "Types", "Activity is occurring that relates to the open metadata types in use by this server."),
    COHORT(12, "Cohort", "The server is exchanging registration information about an open metadata repository cohort that it is connecting to."),
    TRACE(13, "Trace", "This is additional information on the operation of the server that may be of assistance in debugging a problem.  It is not normally logged to any destination, but can be added when needed."),
    PERFMON(14, "PerfMon", "This log record contains performance monitoring timing information for specific types of processing. It is not normally logged to any destination but can be added when needed."),
    ACTIVITY(15, "Activity", "This log record contains user activity information such as the requests being made and the metadata being accessed.");

    private final int severityCode;
    private final String severityName;
    private final String severityDescription;

    private AuditLogRecordSeverityLevel(int severityCode, String severityName, String severityDescription) {
        this.severityCode = severityCode;
        this.severityName = severityName;
        this.severityDescription = severityDescription;
    }

    @Override
    public int getOrdinal() {
        return this.severityCode;
    }

    @Override
    public String getName() {
        return this.severityName;
    }

    @Override
    public String getDescription() {
        return this.severityDescription;
    }

    public String toString() {
        return "AuditLogRecordSeverityLevel{severityCode=" + this.severityCode + ", severityName='" + this.severityName + "', severityDescription='" + this.severityDescription + "'}";
    }

    public static List<AuditLogRecordSeverity> getSeverityList() {
        return new ArrayList<AuditLogRecordSeverity>(Arrays.asList(AuditLogRecordSeverityLevel.values()));
    }
}

