/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepExecution;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionProcessStepExecutionElement {
    private ElementHeader elementHeader = null;
    private GovernanceActionProcessStepExecution processStepProperties = null;
    private Map<String, List<Map<String, String>>> specification = null;

    public GovernanceActionProcessStepExecutionElement() {
    }

    public GovernanceActionProcessStepExecutionElement(GovernanceActionProcessStepExecutionElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = template.getProcessStepProperties();
            this.specification = template.getSpecification();
        }
    }

    public GovernanceActionProcessStepExecutionElement(GovernanceActionProcessStepElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = new GovernanceActionProcessStepExecution(template.getProcessStepProperties());
            this.specification = template.getSpecification();
        }
    }

    public GovernanceActionProcessStepExecutionElement(EngineActionElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = new GovernanceActionProcessStepExecution(template);
            this.specification = null;
        }
    }

    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public GovernanceActionProcessStepExecution getProcessStepProperties() {
        return this.processStepProperties;
    }

    public void setProcessStepProperties(GovernanceActionProcessStepExecution processStepProperties) {
        this.processStepProperties = processStepProperties;
    }

    public Map<String, List<Map<String, String>>> getSpecification() {
        return this.specification;
    }

    public void setSpecification(Map<String, List<Map<String, String>>> specification) {
        this.specification = specification;
    }

    public String toString() {
        return "GovernanceActionProcessStepElement{elementHeader=" + this.elementHeader + ", processStepProperties=" + this.processStepProperties + ", specification=" + this.specification + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionProcessStepExecutionElement that = (GovernanceActionProcessStepExecutionElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.processStepProperties, that.processStepProperties) && Objects.equals(this.specification, that.specification);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.processStepProperties, this.specification);
    }
}

