/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Deprecated
public enum GovernanceActionStatus {
    REQUESTED(0, 0, "Requested", "The governance action has been created and is pending.", EngineActionStatus.REQUESTED),
    APPROVED(1, 1, "Approved", "The governance action is approved to run.", EngineActionStatus.APPROVED),
    WAITING(2, 2, "Waiting", "The governance action is waiting for its start time or the right conditions to run.", EngineActionStatus.WAITING),
    ACTIVATING(3, 3, "Activating", "The governance action service for the governance action is being initialized in the governance engine.", EngineActionStatus.ACTIVATING),
    IN_PROGRESS(4, 4, "In Progress", "The governance engine is running the associated governance action service for the governance action.", EngineActionStatus.IN_PROGRESS),
    ACTIONED(5, 10, "Actioned", "The governance action service for the governance action has successfully completed processing.", EngineActionStatus.ACTIONED),
    INVALID(6, 11, "Invalid", "The governance action has not been run because it is not appropriate (for example, a false positive).", EngineActionStatus.INVALID),
    IGNORED(7, 12, "Ignored", "The governance action has not been run because a different governance action was chosen.", EngineActionStatus.IGNORED),
    FAILED(8, 13, "Failed", "The governance action service for the governance action failed to execute.", EngineActionStatus.FAILED),
    OTHER(99, 99, "Other", "Undefined or unknown governance action status.", EngineActionStatus.OTHER);

    private static final String ENUM_TYPE_GUID = "a6e698b0-a4f7-4a39-8c80-db0bb0f972e";
    private static final String ENUM_TYPE_NAME = "EngineActionStatus";
    private final String statusName;
    private final String statusDescription;
    private final int statusCode;
    private final int openTypeOrdinal;
    private final EngineActionStatus engineActionStatus;

    private GovernanceActionStatus(int statusCode, int openTypeOrdinal, String statusName, String statusDescription, EngineActionStatus engineActionStatus) {
        this.statusCode = statusCode;
        this.openTypeOrdinal = openTypeOrdinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
        this.engineActionStatus = engineActionStatus;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public EngineActionStatus getEngineActionStatus() {
        return this.engineActionStatus;
    }

    public String toString() {
        return "EngineActionStatus{" + this.statusName + "}";
    }
}

