/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ContactMethodType implements OpenMetadataEnum
{
    EMAIL(0, "9ae0f271-e59b-4212-a123-0cb2e431a4f5", "Email", "Send email.", false),
    PHONE(1, "23c948f2-a878-4827-ad9f-d189df16bf34", "Phone", "Call by phone.", false),
    CHAT(2, "472de896-f9b2-48a9-aed6-728e9006a662", "Chat", "Send chat message.", false),
    PROFILE(3, "d6df84bb-96e7-40c6-926f-3728644912c7", "Profile", "Send comment to personal profile.", false),
    ACCOUNT(4, "dada5489-a1cb-433e-a233-6b481ee93edb", "Account", "Send comment to a social media account.", false),
    OTHER(99, "b9e40635-5fa7-4c5d-89e2-ecd77ba4fbab", "Other", "Another contact mechanism.", false);

    private static final String ENUM_TYPE_GUID = "30e7d8cd-df01-46e8-9247-a24c5650910d";
    private static final String ENUM_TYPE_NAME = "ContactMethodType";
    private static final String ENUM_DESCRIPTION = "Type of mechanism to contact an actor.";
    private static final String ENUM_DESCRIPTION_GUID = "f1a4633e-2890-4952-bef2-1ba47d73f885";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/1/0110-Actors/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ContactMethodType(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, null);
    }

    public String toString() {
        return "ContactMethodType : " + this.name;
    }
}

