/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CrowdSourcingRole implements OpenMetadataEnum
{
    PROPOSER(0, "525078a5-fe45-4bd6-9ac1-9318d3548e6e", "Proposer", "Actor that creates the initial version.", true),
    REVIEWER(1, "6be5948c-c743-41da-bbaf-a0518af3d54a", "Reviewer", "Actor that provided feedback.", false),
    SUPPORTER(2, "cdeeb25b-a05e-4d03-afec-34d3e31c9a53", "Supporter", "Actor that agrees with the definition.", false),
    APPROVER(3, "a7915f4e-890b-40da-aece-2b36ba3d9099", "Approver", "Actor that declares the definition should be used.", false),
    OTHER(99, "a6657027-1008-4e58-b5c7-14e89a6a5cd0", "Other", "Another role.", false);

    private static final String ENUM_TYPE_GUID = "0ded50c2-17cc-4ecf-915e-908e66dbb27f";
    private static final String ENUM_TYPE_NAME = "CrowdSourcingRole";
    private static final String ENUM_DESCRIPTION = "Type of contributor to new information and/or assets.";
    private static final String ENUM_DESCRIPTION_GUID = "e15acff5-137b-4703-8b6b-6e984f68cddd";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/1/0155-Crowd-Sourcing/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private CrowdSourcingRole(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.ROLE_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null);
    }

    public String toString() {
        return "CommunityMembershipType : " + this.name;
    }
}

