/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphNode;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AssetLineageGraphRelationship;

public class AssetLineageGraph
extends AssetLineageGraphNode {
    private List<AssetLineageGraphNode> linkedAssets = null;
    private List<AssetLineageGraphRelationship> lineageRelationships = null;
    private String mermaidGraph = null;

    public AssetLineageGraph() {
    }

    public AssetLineageGraph(AssetLineageGraphNode template) {
        super(template);
    }

    public AssetLineageGraph(AssetLineageGraph template) {
        super(template);
        if (template != null) {
            this.linkedAssets = template.getLinkedAssets();
            this.lineageRelationships = template.getLineageRelationships();
            this.mermaidGraph = template.getMermaidGraph();
        }
    }

    public List<AssetLineageGraphNode> getLinkedAssets() {
        return this.linkedAssets;
    }

    public void setLinkedAssets(List<AssetLineageGraphNode> linkedAssets) {
        this.linkedAssets = linkedAssets;
    }

    public List<AssetLineageGraphRelationship> getLineageRelationships() {
        return this.lineageRelationships;
    }

    public void setLineageRelationships(List<AssetLineageGraphRelationship> lineageRelationships) {
        this.lineageRelationships = lineageRelationships;
    }

    public String getMermaidGraph() {
        return this.mermaidGraph;
    }

    public void setMermaidGraph(String mermaidGraph) {
        this.mermaidGraph = mermaidGraph;
    }

    @Override
    public String toString() {
        return "AssetLineageGraph{linkedAssets=" + this.linkedAssets + ", lineageRelationships=" + this.lineageRelationships + ", mermaidGraph='" + this.mermaidGraph + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetLineageGraph that = (AssetLineageGraph)objectToCompare;
        return Objects.equals(this.linkedAssets, that.linkedAssets) && Objects.equals(this.lineageRelationships, that.lineageRelationships) && Objects.equals(this.mermaidGraph, that.mermaidGraph);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.linkedAssets, this.lineageRelationships, this.mermaidGraph);
    }
}

