/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.assets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.SupplementaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.apis.APIProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.ITInfrastructureProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=APIProperties.class, name="APIProperties"), @JsonSubTypes.Type(value=DataAssetProperties.class, name="DataAssetProperties"), @JsonSubTypes.Type(value=ProcessProperties.class, name="ProcessProperties"), @JsonSubTypes.Type(value=ITInfrastructureProperties.class, name="ITInfrastructureProperties")})
public class AssetProperties
extends SupplementaryProperties {
    private String name = null;
    private String resourceName = null;
    private String versionIdentifier = null;
    private String resourceDescription = null;
    private String deployedImplementationType = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.resourceName = template.getResourceName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.resourceDescription = template.getResourceDescription();
            this.deployedImplementationType = template.getDeployedImplementationType();
        }
    }

    public AssetProperties cloneToAsset(String subTypeName) {
        AssetProperties clone = new AssetProperties(this);
        if (clone.getTypeName() == null) {
            clone.setTypeName(subTypeName);
        }
        return clone;
    }

    public String getName() {
        if (this.name == null) {
            return this.resourceName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    @Override
    public String getDisplayDescription() {
        if (this.displayDescription == null) {
            return this.getResourceDescription();
        }
        return this.displayDescription;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public void setDeployedImplementationType(String deployedImplementationType) {
        this.deployedImplementationType = deployedImplementationType;
    }

    @Override
    public String toString() {
        return "AssetProperties{name='" + this.name + "', resourceName='" + this.resourceName + "', versionIdentifier='" + this.versionIdentifier + "', description='" + this.resourceDescription + "', deployedImplementationType='" + this.deployedImplementationType + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        return Objects.equals(this.name, that.name) && Objects.equals(this.versionIdentifier, that.versionIdentifier) && Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.resourceDescription, that.deployedImplementationType) && Objects.equals(this.resourceDescription, that.resourceDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.resourceName, this.versionIdentifier, this.resourceDescription, this.deployedImplementationType);
    }
}

