/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseQueryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.tabular.TabularColumnProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DatabaseColumnProperties
extends TabularColumnProperties {
    private String formula = null;
    private List<DatabaseQueryProperties> queries = null;

    public DatabaseColumnProperties() {
    }

    public DatabaseColumnProperties(DatabaseColumnProperties template) {
        super(template);
        if (template != null) {
            this.formula = template.getFormula();
            this.queries = template.getQueries();
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public List<DatabaseQueryProperties> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DatabaseQueryProperties> queries) {
        this.queries = queries;
    }

    @Override
    public String toString() {
        return "DatabaseColumnProperties{formula='" + this.formula + "', queries=" + this.queries + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DatabaseColumnProperties that = (DatabaseColumnProperties)objectToCompare;
        return Objects.equals(this.formula, that.formula) && Objects.equals(this.queries, that.queries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.formula, this.queries);
    }
}

