/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredGovernanceServicesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceServiceRequestBody;

public class GovernanceConfigurationClientBase
extends GovernanceConfiguration {
    private final GAFRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private AuditLog auditLog = null;

    public GovernanceConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public GovernanceConfigurationClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, GAFRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLMarker);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    @Override
    public String createGovernanceEngine(String userId, String governanceEngineType, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String engineTypeParameterName = "governanceEngineType";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceEngine");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "createGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceEngine");
        NewGovernanceEngineRequestBody requestBody = new NewGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceEngine", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, governanceEngineType);
        return restResult.getGUID();
    }

    @Override
    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEngineGetRESTCall("getGovernanceEngineByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/by-name";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceEngineByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        GovernanceEngineElementResponse restResult = this.restClient.callGovernanceEnginePostRESTCall("getGovernanceEngineByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getElement();
    }

    @Override
    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, String governanceEngineType, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        String engineTypeParameterName = "governanceEngineType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceEngines");
        this.invalidParameterHandler.validateName(governanceEngineType, "governanceEngineType", "getAllGovernanceEngines");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse restResult = this.restClient.callGovernanceEnginesGetRESTCall("getAllGovernanceEngines", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineType, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    @Override
    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        UpdateGovernanceEngineRequestBody requestBody = new UpdateGovernanceEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setTypeDescription(typeDescription);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceEngine", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceEngine", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public String createGovernanceService(String userId, String governanceServiceType, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceService";
        String serviceTypeParameterName = "governanceServiceType";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/types/{3}";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceService");
        this.invalidParameterHandler.validateName(governanceServiceType, "governanceServiceType", "createGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "createGovernanceService");
        NewGovernanceServiceRequestBody requestBody = new NewGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceService", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, governanceServiceType);
        return restResult.getGUID();
    }

    @Override
    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServiceGetRESTCall("getGovernanceServiceByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/by-name";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceServiceByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        GovernanceServiceElementResponse restResult = this.restClient.callGovernanceServicePostRESTCall("getGovernanceServiceByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getElement();
    }

    @Override
    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllGovernanceServices");
        GovernanceServiceElementsResponse restResult = this.restClient.callGovernanceServicesGetRESTCall("getAllGovernanceServices", urlTemplate, this.serverName, this.serviceURLMarker, userId, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getElements();
    }

    @Override
    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceRegistrations";
        String guidParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/{3}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServiceRegistrations");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getGovernanceServiceRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getGovernanceServiceRegistrations", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceServiceGUID);
        return restResult.getGUIDs();
    }

    @Override
    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "updateGovernanceService");
        UpdateGovernanceServiceRequestBody requestBody = new UpdateGovernanceServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceService", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public void deleteGovernanceService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-services/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteGovernanceService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceService");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteGovernanceService", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    @Deprecated
    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.registerGovernanceServiceWithEngine(userId, governanceEngineGUID, governanceServiceGUID, governanceRequestType, null, requestParameters);
    }

    @Override
    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypesParameter = "governanceRequestType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/governance-services";
        this.invalidParameterHandler.validateUserId(userId, "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        GovernanceServiceRegistrationRequestBody requestBody = new GovernanceServiceRegistrationRequestBody();
        requestBody.setGovernanceServiceGUID(governanceServiceGUID);
        requestBody.setRequestType(governanceRequestType);
        requestBody.setServiceRequestType(serviceRequestType);
        requestBody.setRequestParameters(requestParameters);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("registerGovernanceServiceWithEngine", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException(restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(restResult);
    }

    @Override
    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/governance-services/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse restResult = this.restClient.callRegisteredGovernanceServiceGetRESTCall("getRegisteredGovernanceService", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID);
        return restResult.getRegisteredGovernanceService();
    }

    @Override
    public List<RegisteredGovernanceServiceElement> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/governance-services?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredGovernanceServices");
        RegisteredGovernanceServicesResponse restResult = this.restClient.callRegisteredGovernanceServicesGetRESTCall("getRegisteredGovernanceServices", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/governance-engines/{3}/governance-services/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        this.restClient.callVoidPostRESTCall("unregisterGovernanceServiceFromEngine", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, governanceServiceGUID);
    }

    @Override
    public String createIntegrationGroup(String userId, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationGroup";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "createIntegrationGroup");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationGroup");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/by-name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationGroupByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationGroupByName");
        IntegrationGroupElementResponse restResult = this.restClient.callIntegrationGroupGetRESTCall("getIntegrationGroupByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getElement();
    }

    @Override
    public List<IntegrationGroupElement> getAllIntegrationGroups(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationGroups";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationGroups");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse restResult = this.restClient.callIntegrationGroupsGetRESTCall("getAllIntegrationGroups", urlTemplate, this.serverName, this.serviceURLMarker, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void updateIntegrationGroup(String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/update?isMergeUpdate={4}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateIntegrationGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationGroup");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, guid, isMergeUpdate);
    }

    @Override
    public void deleteIntegrationGroup(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationGroup";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationGroup");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationGroup");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationGroup");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationGroup", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public String createIntegrationConnector(String userId, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationConnector";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/new";
        this.invalidParameterHandler.validateUserId(userId, "createIntegrationConnector");
        this.invalidParameterHandler.validateObject(properties, "properties", "createIntegrationConnector");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "createIntegrationConnector");
        this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "createIntegrationConnector");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIntegrationConnector", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getElement();
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/by-name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorByName");
        this.invalidParameterHandler.validateName(name, "name", "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse restResult = this.restClient.callIntegrationConnectorGetRESTCall("getIntegrationConnectorByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getElement();
    }

    @Override
    public List<IntegrationConnectorElement> getAllIntegrationConnectors(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse restResult = this.restClient.callIntegrationConnectorsGetRESTCall("getAllIntegrationConnectors", urlTemplate, this.serverName, this.serviceURLMarker, userId, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public List<String> getIntegrationConnectorRegistrations(String userId, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorRegistrations";
        String guidParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationConnectorRegistrations");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getIntegrationConnectorRegistrations");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getIntegrationConnectorRegistrations", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID);
        return restResult.getGUIDs();
    }

    @Override
    public void updateIntegrationConnector(String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationConnector";
        String guidParameterName = "guid";
        String propertiesParameterName = "properties";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/update?isMergeUpdate={4}";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateIntegrationConnector");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateIntegrationConnector");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationConnector");
            this.invalidParameterHandler.validateConnection(properties.getConnection(), "connection", "updateIntegrationConnector");
        }
        this.restClient.callVoidPostRESTCall("updateIntegrationConnector", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, guid, isMergeUpdate);
    }

    @Override
    public void deleteIntegrationConnector(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationConnector";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationConnector");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteIntegrationConnector");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationConnector");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        this.restClient.callVoidPostRESTCall("deleteIntegrationConnector", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, guid);
    }

    @Override
    public void registerIntegrationConnectorWithGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerIntegrationConnectorWithGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String propertiesParameterName = "properties";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors{4}";
        this.invalidParameterHandler.validateUserId(userId, "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateObject(properties, "properties", "registerIntegrationConnectorWithGroup");
        this.restClient.callVoidPostRESTCall("registerIntegrationConnectorWithGroup", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnector";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse restResult = this.restClient.callRegisteredIntegrationConnectorGetRESTCall("getRegisteredIntegrationConnector", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
        return restResult.getRegisteredIntegrationConnector();
    }

    @Override
    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String userId, String integrationGroupGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnectors";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnectors");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse restResult = this.restClient.callRegisteredIntegrationConnectorsGetRESTCall("getRegisteredIntegrationConnectors", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void unregisterIntegrationConnectorFromGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-groups/{3}/integration-connectors/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "unregisterIntegrationConnectorFromGroup");
        this.restClient.callVoidPostRESTCall("unregisterIntegrationConnectorFromGroup", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public String addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject(properties, "properties", "addCatalogTarget");
        GUIDResponse response = this.restClient.callGUIDPostRESTCall("addCatalogTarget", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
        return response.getGUID();
    }

    @Override
    public void updateCatalogTarget(String userId, String relationshipGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/catalog-targets/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject(properties, "properties", "addCatalogTarget");
        this.restClient.callVoidPostRESTCall("addCatalogTarget", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public CatalogTarget getCatalogTarget(String userId, String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/catalog-targets/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "getCatalogTarget");
        CatalogTargetResponse restResult = this.restClient.callCatalogTargetGetRESTCall("getCatalogTarget", urlTemplate, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
        return restResult.getElement();
    }

    @Override
    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{2}/catalog-targets?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        CatalogTargetsResponse restResult = this.restClient.callCatalogTargetsGetRESTCall("getCatalogTargets", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    @Override
    public void removeCatalogTarget(String userId, String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/catalog-targets/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "removeCatalogTarget");
        this.restClient.callVoidPostRESTCall("removeCatalogTarget", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }
}

