/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.CommentConversation;
import org.odpi.openmetadata.frameworks.connectors.properties.Comments;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedCommentReplies;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.CommentResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.CommentsResponse;

public class ConnectedComments
extends Comments {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformURLRoot;
    private String assetGUID;
    private int maxCacheSize;
    private OCFRESTClient restClient;
    private static final long serialVersionUID = 1L;

    ConnectedComments(String serviceName, String serverName, String userId, String platformURLRoot, String assetGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.assetGUID = assetGUID;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedComments(ConnectedComments template) {
        super(template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    @Override
    protected Comments cloneIterator() {
        return new ConnectedComments(this);
    }

    @Override
    protected ElementBase cloneElement(ElementBase template) {
        if (template instanceof CommentConversation) {
            return new CommentConversation((CommentConversation)template);
        }
        if (template instanceof Comment) {
            return new CommentConversation((Comment)template);
        }
        return null;
    }

    @Override
    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "Comments.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            CommentsResponse restResult = this.restClient.callOCFCommentsGetRESTCall("Comments.getCachedList", this.platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            restExceptionHandler.detectAndThrowPropertyServerException(restResult);
            List<CommentResponse> Responses = restResult.getList();
            if (Responses == null || Responses.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (CommentResponse commentResponse : Responses) {
                if (commentResponse == null) continue;
                Comment bean = commentResponse.getComment();
                ConnectedCommentReplies commentReplies = new ConnectedCommentReplies(this.serviceName, this.serverName, this.userId, this.platformURLRoot, bean.getGUID(), this.maxCacheSize, this.restClient);
                resultList.add(new CommentConversation(bean, commentReplies));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "Comments.getCachedList", this.serverName, this.platformURLRoot);
            return null;
        }
    }
}

