/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventErrorCode;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OMRSTypeDefEventErrorCode implements Serializable
{
    NOT_IN_USE(0, "No Error", "There has been no error detected and so the error code is not in use.", null),
    CONFLICTING_TYPEDEFS(1, "ConflictingTypeDefs", "There are conflicting type definitions (TypeDefs) detected between two repositories in the open metadata repository cohort.", OMRSEventErrorCode.CONFLICTING_TYPEDEFS),
    CONFLICTING_ATTRIBUTE_TYPEDEFS(2, "ConflictingAttributeTypeDefs", "There are conflicting attribute type definitions (AttributeTypeDefs) detected between two repositories in the open metadata repository cohort.", OMRSEventErrorCode.CONFLICTING_ATTRIBUTE_TYPEDEFS),
    TYPEDEF_PATCH_MISMATCH(3, "TypeDefPatchMismatch", "There are different versions of a TypeDef in use in the cohort", OMRSEventErrorCode.TYPEDEF_PATCH_MISMATCH),
    UNKNOWN_ERROR_CODE(99, "Unknown Error Code", "Unrecognized error code from incoming event.", null);

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;
    private OMRSEventErrorCode encoding;

    private OMRSTypeDefEventErrorCode(int ordinal, String name, String description, OMRSEventErrorCode encoding) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
        this.encoding = encoding;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OMRSEventErrorCode getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "OMRSTypeDefEventErrorCode{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "', encoding=" + this.encoding + "}";
    }
}

