/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.templatemanager.server;

import org.odpi.openmetadata.accessservices.digitalarchitecture.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.TemplateManager;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class TemplateManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.TEMPLATE_MANAGER;
    private final TemplateManager templateManager;
    private final OpenMetadataStoreClient openMetadataStoreClient;

    public TemplateManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.templateManager = new TemplateManager(remoteServerName, remoteServerURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public TemplateManager getTemplateManagerClient() {
        return this.templateManager;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }
}

