/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.templatemanager.server;

import org.odpi.openmetadata.accessservices.digitalarchitecture.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ArchiveRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewOpenMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.templatemanager.server.TemplateManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class TemplateManagerRESTServices
extends TokenController {
    private static final TemplateManagerInstanceHandler instanceHandler = new TemplateManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(TemplateManagerRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createMetadataElementInStore(String serverName, NewOpenMetadataElementRequestBody requestBody) {
        String methodName = "createMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createMetadataElementInStore");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "createMetadataElementInStore");
            if (requestBody != null) {
                response.setGUID(handler.createMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getInitialStatus(), requestBody.getInitialClassifications(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataElementFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createMetadataElementFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createMetadataElementFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createMetadataElementFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataElementFromTemplate");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "createMetadataElementFromTemplate");
            if (requestBody != null) {
                response.setGUID(handler.createMetadataElementFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createMetadataElementFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataElementFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementInStore(String serverName, String metadataElementGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateMetadataElementInStore");
            if (requestBody != null) {
                handler.updateMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementStatusInStore(String serverName, String metadataElementGUID, UpdateStatusRequestBody requestBody) {
        String methodName = "updateMetadataElementStatusInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateMetadataElementStatusInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateMetadataElementStatusInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementStatusInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateMetadataElementStatusInStore");
            if (requestBody != null) {
                handler.updateMetadataElementStatusInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getNewStatus(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementStatusInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementStatusInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateMetadataElementEffectivityInStore(String serverName, String metadataElementGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateMetadataElementEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateMetadataElementEffectivityInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateMetadataElementEffectivityInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateMetadataElementEffectivityInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateMetadataElementEffectivityInStore");
            if (requestBody != null) {
                handler.updateMetadataElementEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateMetadataElementEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateMetadataElementEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteMetadataElementInStore(String serverName, String metadataElementGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "deleteMetadataElementInStore");
            if (requestBody != null) {
                handler.deleteMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveMetadataElementInStore(String serverName, String metadataElementGUID, ArchiveRequestBody requestBody) {
        String methodName = "archiveMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "archiveMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "archiveMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "archiveMetadataElementInStore");
            if (requestBody != null) {
                handler.archiveMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, requestBody.getArchiveProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "archiveMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "archiveMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyMetadataElementInStore(String serverName, String metadataElementGUID, String classificationName, NewClassificationRequestBody requestBody) {
        String methodName = "classifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "classifyMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "classifyMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "classifyMetadataElementInStore");
            if (requestBody != null) {
                handler.classifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "classifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "classifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reclassifyMetadataElementInStore(String serverName, String metadataElementGUID, String classificationName, UpdatePropertiesRequestBody requestBody) {
        String methodName = "reclassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "reclassifyMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "reclassifyMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reclassifyMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "reclassifyMetadataElementInStore");
            if (requestBody != null) {
                handler.reclassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "reclassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "reclassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateClassificationEffectivityInStore(String serverName, String metadataElementGUID, String classificationName, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateClassificationEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateClassificationEffectivityInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateClassificationEffectivityInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateClassificationEffectivityInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateClassificationEffectivityInStore");
            if (requestBody != null) {
                handler.updateClassificationEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateClassificationEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateClassificationEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse declassifyMetadataElementInStore(String serverName, String metadataElementGUID, String classificationName, UpdateRequestBody requestBody) {
        String methodName = "declassifyMetadataElementInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "declassifyMetadataElementInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "declassifyMetadataElementInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "declassifyMetadataElementInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "declassifyMetadataElementInStore");
            if (requestBody != null) {
                handler.declassifyMetadataElementInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), metadataElementGUID, classificationName, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "declassifyMetadataElementInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "declassifyMetadataElementInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createRelatedElementsInStore(String serverName, NewRelatedElementsRequestBody requestBody) {
        String methodName = "createRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createRelatedElementsInStore");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createRelatedElementsInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createRelatedElementsInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "createRelatedElementsInStore");
            if (requestBody != null) {
                response.setGUID(handler.createRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getMetadataElement1GUID(), requestBody.getMetadataElement2GUID(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getProperties(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsInStore(String serverName, String relationshipGUID, UpdatePropertiesRequestBody requestBody) {
        String methodName = "updateRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateRelatedElementsInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateRelatedElementsInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateRelatedElementsInStore");
            if (requestBody != null) {
                handler.updateRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getReplaceProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getProperties(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateRelatedElementsEffectivityInStore(String serverName, String relationshipGUID, UpdateEffectivityDatesRequestBody requestBody) {
        String methodName = "updateRelatedElementsEffectivityInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateRelatedElementsEffectivityInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateRelatedElementsEffectivityInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateRelatedElementsEffectivityInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "updateRelatedElementsEffectivityInStore");
            if (requestBody != null) {
                handler.updateRelatedElementsEffectivityInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateRelatedElementsEffectivityInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateRelatedElementsEffectivityInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteRelatedElementsInStore(String serverName, String relationshipGUID, UpdateRequestBody requestBody) {
        String methodName = "deleteRelatedElementsInStore";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteRelatedElementsInStore");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteRelatedElementsInStore");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteRelatedElementsInStore");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "deleteRelatedElementsInStore");
            if (requestBody != null) {
                handler.deleteRelatedElementsInStore(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), relationshipGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteRelatedElementsInStore", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteRelatedElementsInStore", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

