/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.templatemanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.viewservices.templatemanager.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.viewservices.templatemanager.server.TemplateManagerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/template-manager"})
@Tag(name="API: Template Manager OMVS", description="The Template Manager OMVS provides APIs for retrieving, creating and maintaining templates.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/template-manager/overview/"))
public class TemplateManagerResource {
    private final TemplateManagerRESTServices restAPI = new TemplateManagerRESTServices();

    @PostMapping(path={"/templates/by-search-string"})
    @Operation(summary="findTemplates", description="Retrieve the metadata elements that contain the requested string in its template classification.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
    public OpenMetadataElementsResponse findTemplates(@PathVariable String serverName, @RequestParam(required=false) String elementTypeName, @RequestParam(required=false) String viewServiceURLMarker, @RequestParam(required=false, defaultValue="digital-architecture") String accessServiceURLMarker, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody TemplateClassificationRequestBody requestBody) {
        return this.restAPI.findTemplates(serverName, elementTypeName, viewServiceURLMarker, accessServiceURLMarker, startFrom, pageSize, requestBody);
    }
}

