/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.templatemanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ArchiveRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewOpenMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.viewservices.templatemanager.server.TemplateManagerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/template-manager"})
@Tag(name="API: Template Manager OMVS", description="The Template Manager OMVS provides APIs for retrieving, creating and maintaining templates.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/template-manager/overview/"))
public class TemplateManagerResource {
    private final TemplateManagerRESTServices restAPI = new TemplateManagerRESTServices();

    @PostMapping(path={"/metadata-elements"})
    public GUIDResponse createMetadataElementInStore(@PathVariable String serverName, @RequestBody NewOpenMetadataElementRequestBody requestBody) {
        return this.restAPI.createMetadataElementInStore(serverName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/from-template"})
    public GUIDResponse createMetadataElementFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createMetadataElementFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-properties"})
    public VoidResponse updateMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementInStore(serverName, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-status"})
    public VoidResponse updateMetadataElementStatusInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @RequestBody UpdateStatusRequestBody requestBody) {
        return this.restAPI.updateMetadataElementStatusInStore(serverName, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/update-effectivity"})
    public VoidResponse updateMetadataElementEffectivityInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementEffectivityInStore(serverName, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/delete"})
    public VoidResponse deleteMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @RequestBody(required=false) UpdateRequestBody requestBody) {
        return this.restAPI.deleteMetadataElementInStore(serverName, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/archive"})
    public VoidResponse archiveMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @RequestBody(required=false) ArchiveRequestBody requestBody) {
        return this.restAPI.archiveMetadataElementInStore(serverName, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}"})
    public VoidResponse classifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody NewClassificationRequestBody requestBody) {
        return this.restAPI.classifyMetadataElementInStore(serverName, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-properties"})
    public VoidResponse reclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.reclassifyMetadataElementInStore(serverName, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-effectivity"})
    public VoidResponse updateClassificationEffectivityInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateClassificationEffectivityInStore(serverName, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/delete"})
    public VoidResponse declassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.declassifyMetadataElementInStore(serverName, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/related-elements"})
    public GUIDResponse createRelatedElementsInStore(@PathVariable String serverName, @RequestBody NewRelatedElementsRequestBody requestBody) {
        return this.restAPI.createRelatedElementsInStore(serverName, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-properties"})
    public VoidResponse updateRelatedElementsInStore(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsInStore(serverName, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/update-effectivity"})
    public VoidResponse updateRelatedElementsEffectivityInStore(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsEffectivityInStore(serverName, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/related-elements/{relationshipGUID}/delete"})
    public VoidResponse deleteRelatedElementsInStore(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteRelatedElementsInStore(serverName, relationshipGUID, requestBody);
    }
}

