/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.api.ffdc;

import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewErrorCode;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewServiceException;

public class TexExceptionHandler {
    public static void captureCheckedException(FFDCResponse response, OCFCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        if (error.getReportedCaughtException() != null) {
            response.setExceptionCausedBy(error.getReportedCaughtException().getClass().getName());
        }
        response.setActionDescription(error.getReportingActionDescription());
        String fullErrorMessage = error.getReportedErrorMessage();
        String errorMessageId = error.getReportedErrorMessageId();
        String trimmedErrorMessage = fullErrorMessage.substring(errorMessageId.length() + 1);
        response.setExceptionErrorMessage(trimmedErrorMessage);
        response.setExceptionErrorMessageId(error.getReportedErrorMessageId());
        response.setExceptionErrorMessageParameters(error.getReportedErrorMessageParameters());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(null);
    }

    public static TexViewServiceException mapOMRSUserNotAuthorizedException(String className, String methodName, UserNotAuthorizedException repositoryException) {
        String userId = repositoryException.getUserId();
        return new TexViewServiceException(TexViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(userId), className, methodName);
    }

    public static TexViewServiceException mapOMRSRepositoryErrorException(String className, String methodName, RepositoryErrorException repositoryException) {
        switch (repositoryException.getReportedErrorMessageId()) {
            case "OMAG-MULTI-TENANT-404-001": {
                String serverName = repositoryException.getReportedErrorMessageParameters()[0];
                return new TexViewServiceException(TexViewErrorCode.REPOSITORY_NOT_AVAILABLE.getMessageDefinition(methodName, serverName), className, methodName);
            }
            case "OMRS-REST-API-503-006": {
                String serverName = repositoryException.getReportedErrorMessageParameters()[1];
                return new TexViewServiceException(TexViewErrorCode.PLATFORM_NOT_AVAILABLE.getMessageDefinition(methodName, serverName), className, methodName);
            }
        }
        String message = repositoryException.getReportedErrorMessage();
        return new TexViewServiceException(TexViewErrorCode.REPOSITORY_ERROR.getMessageDefinition(methodName, message), className, methodName);
    }

    public static TexViewServiceException mapOMRSInvalidParameterException(String className, String methodName, InvalidParameterException repositoryException) {
        String parameterName = repositoryException.getReportedErrorMessageParameters()[0];
        if (parameterName.equals("searchCriteria")) {
            parameterName = "Search Text";
        }
        return new TexViewServiceException(TexViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, parameterName), className, methodName);
    }
}

