/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.api.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.viewservices.tex.api.properties.ClassificationExplorer;
import org.odpi.openmetadata.viewservices.tex.api.properties.EntityExplorer;
import org.odpi.openmetadata.viewservices.tex.api.properties.RelationshipExplorer;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TypeExplorer {
    private Map<String, EntityExplorer> entities = new HashMap<String, EntityExplorer>();
    private Map<String, RelationshipExplorer> relationships = new HashMap<String, RelationshipExplorer>();
    private Map<String, ClassificationExplorer> classifications = new HashMap<String, ClassificationExplorer>();
    private Map<String, EnumDef> enums = new HashMap<String, EnumDef>();
    private Map<String, String> entityTypeGUIDToName = new HashMap<String, String>();
    private Map<String, String> entityTypeNameToGUID = new HashMap<String, String>();
    private Map<String, String> relationshipTypeGUIDToName = new HashMap<String, String>();
    private Map<String, String> relationshipTypeNameToGUID = new HashMap<String, String>();

    public Map<String, EntityExplorer> getEntities() {
        return this.entities;
    }

    public Map<String, RelationshipExplorer> getRelationships() {
        return this.relationships;
    }

    public Map<String, ClassificationExplorer> getClassifications() {
        return this.classifications;
    }

    public Map<String, EnumDef> getEnums() {
        return this.enums;
    }

    public Map<String, String> getEntityTypeGUIDToName() {
        return this.entityTypeGUIDToName;
    }

    public Map<String, String> getEntityTypeNameToGUID() {
        return this.entityTypeNameToGUID;
    }

    public Map<String, String> getRelationshipTypeGUIDToName() {
        return this.relationshipTypeGUIDToName;
    }

    public Map<String, String> getRelationshipTypeNameToGUID() {
        return this.relationshipTypeNameToGUID;
    }

    public void addEntityExplorer(String entityTypeName, EntityExplorer entityExplorer) {
        this.entities.put(entityTypeName, entityExplorer);
        String typeGUID = entityExplorer.getEntityDef().getGUID();
        this.entityTypeGUIDToName.put(typeGUID, entityTypeName);
        this.entityTypeNameToGUID.put(entityTypeName, typeGUID);
    }

    public void addRelationshipExplorer(String relationshipTypeName, RelationshipExplorer relationshipExplorer) {
        this.relationships.put(relationshipTypeName, relationshipExplorer);
        String typeGUID = relationshipExplorer.getRelationshipDef().getGUID();
        this.relationshipTypeGUIDToName.put(typeGUID, relationshipTypeName);
        this.relationshipTypeNameToGUID.put(relationshipTypeName, typeGUID);
    }

    public void addClassificationExplorer(String classificationTypeName, ClassificationExplorer classificationExplorer) {
        this.classifications.put(classificationTypeName, classificationExplorer);
    }

    public void addEnumExplorer(String enumTypeName, EnumDef enumDef) {
        this.enums.put(enumTypeName, enumDef);
    }

    public void resolve(boolean includeDeprecatedTypes) {
        this.resolveEntities(includeDeprecatedTypes);
        this.resolveRelationships(includeDeprecatedTypes);
        this.resolveClassifications(includeDeprecatedTypes);
    }

    private void resolveEntities(boolean includeDeprecatedTypes) {
        EntityExplorer superTypeExplorer;
        String superTypeName;
        TypeDefLink superType;
        EntityExplorer entityExplorer;
        HashMap<String, EntityExplorer> includedEntities = new HashMap<String, EntityExplorer>();
        for (String entityTypeName : this.entities.keySet()) {
            entityExplorer = this.entities.get(entityTypeName);
            EntityDef entityDef = entityExplorer.getEntityDef();
            if (!includeDeprecatedTypes && entityDef.getStatus() == TypeDefStatus.DEPRECATED_TYPEDEF) continue;
            includedEntities.put(entityTypeName, entityExplorer);
        }
        this.entities = includedEntities;
        for (String entityTypeName : this.entities.keySet()) {
            entityExplorer = this.entities.get(entityTypeName);
            superType = entityExplorer.getEntityDef().getSuperType();
            if (superType == null) continue;
            superTypeName = superType.getName();
            superTypeExplorer = this.entities.get(superTypeName);
            superTypeExplorer.addSubTypName(entityTypeName);
        }
        for (String entityTypeName : this.entities.keySet()) {
            entityExplorer = this.entities.get(entityTypeName);
            superType = entityExplorer.getEntityDef().getSuperType();
            while (superType != null) {
                superTypeName = superType.getName();
                superTypeExplorer = this.entities.get(superTypeName);
                EntityDef superDef = superTypeExplorer.getEntityDef();
                List superAttributes = superDef.getPropertiesDefinition();
                entityExplorer.addInheritedAttributes(superAttributes);
                superType = superDef.getSuperType();
            }
        }
    }

    private void resolveRelationships(boolean includeDeprecatedTypes) {
        RelationshipExplorer relationshipExplorer;
        HashMap<String, RelationshipExplorer> includedRelationships = new HashMap<String, RelationshipExplorer>();
        for (String relationshipTypeName : this.relationships.keySet()) {
            relationshipExplorer = this.relationships.get(relationshipTypeName);
            RelationshipDef relationshipDef = relationshipExplorer.getRelationshipDef();
            if (!includeDeprecatedTypes && relationshipDef.getStatus() == TypeDefStatus.DEPRECATED_TYPEDEF) continue;
            includedRelationships.put(relationshipTypeName, relationshipExplorer);
        }
        this.relationships = includedRelationships;
        for (String relationshipTypeName : this.relationships.keySet()) {
            String entityTwoTypeName;
            EntityExplorer entityTwoExplorer;
            List<String> subTypeNames;
            String entityOneTypeName;
            EntityExplorer entityOneExplorer;
            relationshipExplorer = this.relationships.get(relationshipTypeName);
            RelationshipEndDef entityOneDef = relationshipExplorer.getRelationshipDef().getEndDef1();
            RelationshipEndDef entityTwoDef = relationshipExplorer.getRelationshipDef().getEndDef2();
            if (entityOneDef != null && (entityOneExplorer = this.entities.get(entityOneTypeName = entityOneDef.getEntityType().getName())) != null) {
                entityOneExplorer.addRelationship(relationshipTypeName);
                subTypeNames = entityOneExplorer.getSubTypeNames();
                for (String subTypeName : subTypeNames) {
                    this.addRelationshipToSubType(relationshipTypeName, subTypeName);
                }
            }
            if (entityTwoDef == null || (entityTwoExplorer = this.entities.get(entityTwoTypeName = entityTwoDef.getEntityType().getName())) == null) continue;
            entityTwoExplorer.addRelationship(relationshipTypeName);
            subTypeNames = entityTwoExplorer.getSubTypeNames();
            for (String subTypeName : subTypeNames) {
                this.addRelationshipToSubType(relationshipTypeName, subTypeName);
            }
        }
    }

    private void addRelationshipToSubType(String relationshipTypeName, String entityTypeName) {
        EntityExplorer entityExplorer = this.entities.get(entityTypeName);
        entityExplorer.addInheritedRelationship(relationshipTypeName);
        List<String> subTypeNames = entityExplorer.getSubTypeNames();
        if (!subTypeNames.isEmpty()) {
            for (String subTypeName : subTypeNames) {
                this.addRelationshipToSubType(relationshipTypeName, subTypeName);
            }
        }
    }

    private void resolveClassifications(boolean includeDeprecatedTypes) {
        ClassificationExplorer superTypeExplorer;
        String superTypeName;
        TypeDefLink superType;
        ClassificationExplorer classificationExplorer;
        HashMap<String, ClassificationExplorer> includedClassifications = new HashMap<String, ClassificationExplorer>();
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = this.classifications.get(classificationTypeName);
            ClassificationDef classificationDef = classificationExplorer.getClassificationDef();
            if (!includeDeprecatedTypes && classificationDef.getStatus() == TypeDefStatus.DEPRECATED_TYPEDEF) continue;
            includedClassifications.put(classificationTypeName, classificationExplorer);
        }
        this.classifications = includedClassifications;
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = this.classifications.get(classificationTypeName);
            List validEntityTypes = classificationExplorer.getClassificationDef().getValidEntityDefs();
            if (validEntityTypes == null) continue;
            for (TypeDefLink entityType : validEntityTypes) {
                String entityTypeName = entityType.getName();
                EntityExplorer entityExplorer = this.entities.get(entityTypeName);
                if (entityExplorer == null) continue;
                entityExplorer.addClassification(classificationTypeName);
                List<String> subTypeNames = entityExplorer.getSubTypeNames();
                for (String subTypeName : subTypeNames) {
                    this.addClassificationToSubType(classificationTypeName, subTypeName);
                }
            }
        }
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = this.classifications.get(classificationTypeName);
            superType = classificationExplorer.getClassificationDef().getSuperType();
            if (superType == null) continue;
            superTypeName = superType.getName();
            superTypeExplorer = this.classifications.get(superTypeName);
            superTypeExplorer.addSubTypName(classificationTypeName);
        }
        for (String classificationTypeName : this.classifications.keySet()) {
            classificationExplorer = this.classifications.get(classificationTypeName);
            superType = classificationExplorer.getClassificationDef().getSuperType();
            while (superType != null) {
                superTypeName = superType.getName();
                superTypeExplorer = this.classifications.get(superTypeName);
                ClassificationDef superDef = superTypeExplorer.getClassificationDef();
                List superAttributes = superDef.getPropertiesDefinition();
                classificationExplorer.addInheritedAttributes(superAttributes);
                superType = superDef.getSuperType();
            }
        }
    }

    private void addClassificationToSubType(String classificationTypeName, String entityTypeName) {
        EntityExplorer entityExplorer = this.entities.get(entityTypeName);
        entityExplorer.addInheritedClassification(classificationTypeName);
        List<String> subTypeNames = entityExplorer.getSubTypeNames();
        if (!subTypeNames.isEmpty()) {
            for (String subTypeName : subTypeNames) {
                this.addClassificationToSubType(classificationTypeName, subTypeName);
            }
        }
    }

    public String getEntityTypeName(String entityTypeGUID) {
        return this.entityTypeGUIDToName.get(entityTypeGUID);
    }

    public String getEntityTypeGUID(String entityTypeName) {
        return this.entityTypeNameToGUID.get(entityTypeName);
    }

    public String getRelationshipTypeName(String relationshipTypeGUID) {
        return this.entityTypeGUIDToName.get(relationshipTypeGUID);
    }

    public String getRelationshipTypeGUID(String relationshipTypeName) {
        return this.relationshipTypeNameToGUID.get(relationshipTypeName);
    }

    public String toString() {
        return "TypeExplorer{entities=" + this.entities + ", relationships=" + this.relationships + ", classifications=" + this.classifications + '}';
    }
}

