/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.api.properties;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class EntityExplorer {
    private EntityDef entityDef;
    private List<TypeDefAttribute> inheritedAttributes;
    private List<String> subTypeNames;
    private List<String> classificationNames;
    private List<String> relationshipNames;
    private List<String> inheritedRelationshipNames;
    private List<String> inheritedClassificationNames;

    public EntityExplorer(EntityDef def) {
        this.entityDef = def;
        this.inheritedAttributes = new ArrayList<TypeDefAttribute>();
        this.subTypeNames = new ArrayList<String>();
        this.classificationNames = new ArrayList<String>();
        this.relationshipNames = new ArrayList<String>();
        this.inheritedRelationshipNames = new ArrayList<String>();
        this.inheritedClassificationNames = new ArrayList<String>();
    }

    public EntityDef getEntityDef() {
        return this.entityDef;
    }

    public List<TypeDefAttribute> getInheritedAttributes() {
        return this.inheritedAttributes;
    }

    public List<String> getSubTypeNames() {
        return this.subTypeNames;
    }

    public List<String> getClassificationNames() {
        return this.classificationNames;
    }

    public List<String> getRelationshipNames() {
        return this.relationshipNames;
    }

    public List<String> getInheritedRelationshipNames() {
        return this.inheritedRelationshipNames;
    }

    public List<String> getInheritedClassificationNames() {
        return this.inheritedClassificationNames;
    }

    public void addSubTypName(String subTypeName) {
        this.subTypeNames.add(subTypeName);
    }

    public void addInheritedAttributes(List<TypeDefAttribute> inheritedAttrs) {
        if (inheritedAttrs != null) {
            this.inheritedAttributes.addAll(inheritedAttrs);
        }
    }

    public void addRelationship(String relationshipTypeName) {
        if (relationshipTypeName != null) {
            this.relationshipNames.add(relationshipTypeName);
        }
    }

    public void addInheritedRelationship(String relationshipTypeName) {
        if (relationshipTypeName != null) {
            this.inheritedRelationshipNames.add(relationshipTypeName);
        }
    }

    public void addClassification(String classificationName) {
        if (classificationName != null) {
            this.classificationNames.add(classificationName);
        }
    }

    public void addInheritedClassification(String classificationName) {
        if (classificationName != null) {
            this.inheritedClassificationNames.add(classificationName);
        }
    }
}

