/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.admin;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewAuditCode;
import org.odpi.openmetadata.viewservices.tex.server.TexViewServicesInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TexViewAdmin
extends ViewServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(TexViewAdmin.class);
    protected String resourceEndpointsPropertyName = "resourceEndpoints";
    private AuditLog auditLog = null;
    private String serverUserName = null;
    private TexViewServicesInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", TexViewAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize");
        }
        IntegrationViewServiceConfig integrationViewServiceConfig = null;
        if (!(viewServiceConfig instanceof IntegrationViewServiceConfig)) {
            this.logBadConfiguration(viewServiceConfig.getViewServiceName(), "viewServiceConfig", viewServiceConfig.toString(), auditLog, "initialize");
            return;
        }
        integrationViewServiceConfig = (IntegrationViewServiceConfig)viewServiceConfig;
        String viewServiceFullName = viewServiceConfig.getViewServiceName();
        try {
            List<ResourceEndpointConfig> resourceEndpoints = this.extractResourceEndpoints(integrationViewServiceConfig.getResourceEndpoints(), viewServiceFullName, auditLog);
            this.instance = new TexViewServicesInstance(serverName, auditLog, serverUserName, maxPageSize, resourceEndpoints);
            this.serverUserName = serverUserName;
            this.serverName = serverName;
            auditLog.logMessage("initialize", TexViewAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{serverName}), viewServiceConfig.toString());
            if (log.isDebugEnabled()) {
                log.debug("<== Method: initialize");
            }
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", TexViewAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), viewServiceConfig.toString(), error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.TYPE_EXPLORER.getViewServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        log.debug("==> Method: shutdown");
        this.auditLog.logMessage("shutdown", TexViewAuditCode.SERVICE_TERMINATING.getMessageDefinition(new String[]{this.serverName}));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", TexViewAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        log.debug("<== Method: shutdown");
    }

    protected List<ResourceEndpointConfig> extractResourceEndpoints(List<ResourceEndpointConfig> resourceEndpoints, String viewServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractResourceEndpoints";
        String parameterName = "resourceEndpoints";
        if (resourceEndpoints == null || resourceEndpoints.isEmpty()) {
            this.logBadConfiguration(viewServiceFullName, this.resourceEndpointsPropertyName, resourceEndpoints == null ? "null" : resourceEndpoints.toString(), auditLog, "extractResourceEndpoints");
            return null;
        }
        List<ResourceEndpointConfig> endpointList = resourceEndpoints;
        auditLog.logMessage("extractResourceEndpoints", OMAGAdminAuditCode.RESOURCE_ENDPOINTS.getMessageDefinition(new String[]{viewServiceFullName, endpointList.toString()}));
        return endpointList;
    }
}

