/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexExceptionHandler;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewErrorCode;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewServiceException;
import org.odpi.openmetadata.viewservices.tex.api.properties.ClassificationExplorer;
import org.odpi.openmetadata.viewservices.tex.api.properties.EntityExplorer;
import org.odpi.openmetadata.viewservices.tex.api.properties.RelationshipExplorer;
import org.odpi.openmetadata.viewservices.tex.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.tex.api.properties.TypeExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TexViewHandler {
    private static final Logger log = LoggerFactory.getLogger(TexViewHandler.class);
    private static final int TRUNCATED_STRING_LENGTH = 24;
    private Map<String, ResourceEndpoint> configuredPlatforms = null;
    private Map<String, ResourceEndpoint> configuredServerInstances = null;

    public TexViewHandler() {
    }

    public TexViewHandler(List<ResourceEndpointConfig> resourceEndpoints) {
        this.configuredPlatforms = new HashMap<String, ResourceEndpoint>();
        this.configuredServerInstances = new HashMap<String, ResourceEndpoint>();
        if (resourceEndpoints != null && !resourceEndpoints.isEmpty()) {
            resourceEndpoints.forEach(res -> {
                String resCategory = res.getResourceCategory();
                ResourceEndpoint rep = new ResourceEndpoint(res);
                String resName = null;
                switch (resCategory) {
                    case "Platform": {
                        resName = res.getPlatformName();
                        this.configuredPlatforms.put(resName, rep);
                        break;
                    }
                    case "Server": {
                        resName = res.getServerInstanceName();
                        this.configuredServerInstances.put(resName, rep);
                        break;
                    }
                }
            });
        }
    }

    public Map<String, List<ResourceEndpoint>> getResourceEndpoints(String userId, String methodName) {
        HashMap<String, List<ResourceEndpoint>> returnMap = new HashMap<String, List<ResourceEndpoint>>();
        ArrayList<ResourceEndpoint> platformList = null;
        ArrayList<ResourceEndpoint> serverList = null;
        if (!this.configuredPlatforms.isEmpty()) {
            platformList = new ArrayList<ResourceEndpoint>();
            platformList.addAll(this.configuredPlatforms.values());
        }
        if (!this.configuredServerInstances.isEmpty()) {
            serverList = new ArrayList<ResourceEndpoint>();
            serverList.addAll(this.configuredServerInstances.values());
        }
        returnMap.put("platformList", platformList);
        returnMap.put("serverList", serverList);
        return returnMap;
    }

    private String resolvePlatformRootURL(String platformName, String methodName) throws TexViewServiceException {
        ResourceEndpoint resource;
        String platformRootURL = null;
        if (platformName != null && (resource = this.configuredPlatforms.get(platformName)) != null) {
            platformRootURL = resource.getResourceRootURL();
        }
        if (platformName == null || platformRootURL == null) {
            throw new TexViewServiceException(TexViewErrorCode.VIEW_SERVICE_NULL_PLATFORM_NAME.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        return platformRootURL;
    }

    public TypeExplorer getTypeExplorer(String userId, String repositoryServerName, String platformName, boolean enterpriseOption, boolean deprecationOption, String methodName) throws TexViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, platformRootURL) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, platformRootURL);
            TypeExplorer tex = new TypeExplorer();
            TypeDefGallery typeDefGallery = repositoryServicesClient.getAllTypes(userId);
            ArrayList typeDefs = typeDefGallery.getTypeDefs();
            for (TypeDef typeDef : typeDefs) {
                TypeDefCategory tdCat = typeDef.getCategory();
                switch (tdCat) {
                    case ENTITY_DEF: {
                        EntityExplorer eex = new EntityExplorer((EntityDef)typeDef);
                        tex.addEntityExplorer(typeDef.getName(), eex);
                        break;
                    }
                    case RELATIONSHIP_DEF: {
                        RelationshipExplorer rex = new RelationshipExplorer((RelationshipDef)typeDef);
                        tex.addRelationshipExplorer(typeDef.getName(), rex);
                        break;
                    }
                    case CLASSIFICATION_DEF: {
                        ClassificationExplorer cex = new ClassificationExplorer((ClassificationDef)typeDef);
                        tex.addClassificationExplorer(typeDef.getName(), cex);
                        break;
                    }
                }
            }
            List attributeTypeDefs = typeDefGallery.getAttributeTypeDefs();
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                AttributeTypeDefCategory tdCat = attributeTypeDef.getCategory();
                switch (tdCat) {
                    case ENUM_DEF: {
                        tex.addEnumExplorer(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                        break;
                    }
                }
            }
            tex.resolve(deprecationOption, platformRootURL, repositoryServerName);
            return tex;
        }
        catch (UserNotAuthorizedException e) {
            throw TexExceptionHandler.mapOMRSUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (UserNotAuthorizedException)e);
        }
        catch (RepositoryErrorException e) {
            throw TexExceptionHandler.mapOMRSRepositoryErrorException((String)this.getClass().getName(), (String)methodName, (RepositoryErrorException)e);
        }
        catch (InvalidParameterException e) {
            throw TexExceptionHandler.mapOMRSInvalidParameterException((String)this.getClass().getName(), (String)methodName, (InvalidParameterException)e);
        }
    }

    private LocalRepositoryServicesClient getLocalRepositoryServicesClient(String serverName, String serverRootURL) throws InvalidParameterException {
        String restRootURL = serverRootURL + "/servers/" + serverName;
        LocalRepositoryServicesClient client = new LocalRepositoryServicesClient(serverName, restRootURL);
        return client;
    }

    private EnterpriseRepositoryServicesClient getEnterpriseRepositoryServicesClient(String serverName, String serverRootURL) throws InvalidParameterException {
        String restRootURL = serverRootURL + "/servers/" + serverName;
        EnterpriseRepositoryServicesClient client = new EnterpriseRepositoryServicesClient(serverName, restRootURL);
        return client;
    }
}

