/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.tex.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexExceptionHandler;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewErrorCode;
import org.odpi.openmetadata.viewservices.tex.api.ffdc.TexViewServiceException;
import org.odpi.openmetadata.viewservices.tex.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.tex.api.rest.TexResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.tex.api.rest.TexTypesRequestBody;
import org.odpi.openmetadata.viewservices.tex.api.rest.TypeExplorerResponse;
import org.odpi.openmetadata.viewservices.tex.handlers.TexViewHandler;
import org.odpi.openmetadata.viewservices.tex.server.TexViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TexViewRESTServices {
    protected static TexViewInstanceHandler instanceHandler = new TexViewInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(TexViewRESTServices.class), instanceHandler.getServiceName());
    private static final Logger log = LoggerFactory.getLogger(TexViewRESTServices.class);

    public TexResourceEndpointListResponse getResourceEndpointList(String serverName, String userId) {
        String methodName = "getResourceEndpointList";
        TexResourceEndpointListResponse response = new TexResourceEndpointListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceEndpointList");
            TexViewHandler handler = instanceHandler.getTexViewHandler(userId, serverName, "getResourceEndpointList");
            Map<String, List<ResourceEndpoint>> lists = handler.getResourceEndpoints(userId, "getResourceEndpointList");
            List<ResourceEndpoint> platformList = null;
            List<ResourceEndpoint> serverList = null;
            if (lists != null) {
                platformList = lists.get("platformList");
                serverList = lists.get("serverList");
            }
            response.setPlatformList(platformList);
            response.setServerList(serverList);
        }
        catch (InvalidParameterException exception) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
        }
        catch (PropertyServerException exception) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
        }
        catch (UserNotAuthorizedException exception) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getResourceEndpointList", auditLog);
        }
        log.debug("Returning from method: getResourceEndpointList with response: " + response.toString());
        return response;
    }

    public TypeExplorerResponse getTypeExplorer(String serverName, String userId, TexTypesRequestBody requestBody) {
        String methodName = "getTypeExplorer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypeExplorer");
        TypeExplorerResponse response = new TypeExplorerResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            TexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeExplorer");
                handler = instanceHandler.getTexViewHandler(userId, serverName, "getTypeExplorer");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getTypeExplorer", auditLog);
            }
            try {
                response.setTypeExplorer(handler.getTypeExplorer(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getDeprecationOption(), "getTypeExplorer"));
            }
            catch (TexViewServiceException exception) {
                TexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getTypeExplorer", auditLog);
            }
        } else {
            TexViewServiceException exception = new TexViewServiceException(TexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "getTypeExplorer");
            TexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: getTypeExplorer with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

