/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.tokencontroller;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.tokencontroller.ffdc.TokenControllerErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class TokenController {
    private static final Logger log = LoggerFactory.getLogger(RESTExceptionHandler.class);

    protected String getUser(String serviceName, String methodName) throws UserNotAuthorizedException {
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        if (userName == null) {
            log.error("No user for service " + serviceName + " and operation " + methodName);
            throw new UserNotAuthorizedException(TokenControllerErrorCode.NO_USER.getMessageDefinition(serviceName, methodName), this.getClass().getName(), methodName, "<null>");
        }
        return userName;
    }
}

