/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.tokencontroller.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum TokenControllerErrorCode implements ExceptionMessageSet
{
    NO_USER(400, "TOKEN-CONTROLLER-401-001", "Call made to {0} service {1} has no logged-on user", "An inbound REST API call has been received but there is no userId in the authorization bearer token.", "Ensure the user acquires a valid token and this token is included in the request header.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private TokenControllerErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

