/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.tokenmanager.http;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.tokenmanager.http.HTTPHeadersThreadLocal;

public class HTTPRequestHeadersFilter
implements Filter {
    private final List<String> headerNames;
    private final boolean saveAllHeaders;

    public HTTPRequestHeadersFilter(List<String> headerNames) {
        if (headerNames == null) {
            this.headerNames = new ArrayList<String>();
            this.saveAllHeaders = false;
        } else {
            this.headerNames = headerNames;
            this.saveAllHeaders = headerNames.contains("*");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HashMap<String, String> threadLocalHeaders = new HashMap<String, String>();
        if (this.saveAllHeaders) {
            Enumeration allHeaders = httpServletRequest.getHeaderNames();
            if (allHeaders != null) {
                while (allHeaders.hasMoreElements()) {
                    String headerName = (String)allHeaders.nextElement();
                    String headerValue = httpServletRequest.getHeader(headerName);
                    if (headerValue == null || headerValue.isEmpty()) continue;
                    threadLocalHeaders.put(headerName, headerValue);
                }
            }
        } else {
            for (String headerName : this.headerNames) {
                String headerValue = httpServletRequest.getHeader(headerName);
                if (headerValue == null || headerValue.isEmpty()) continue;
                threadLocalHeaders.put(headerName, headerValue);
            }
        }
        HTTPHeadersThreadLocal.getHeadersThreadLocal().set(threadLocalHeaders);
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

