/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.topic.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.EventBrokerClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EventTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.TopicElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TopicProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class TopicIntegratorContext {
    private EventBrokerClient client;
    private DataManagerEventClient eventClient;
    private String userId;
    private String eventManagerGUID;
    private String eventManagerName;

    public TopicIntegratorContext(EventBrokerClient client, DataManagerEventClient eventClient, String userId, String eventManagerGUID, String eventManagerName) {
        this.client = client;
        this.eventClient = eventClient;
        this.userId = userId;
        this.eventManagerGUID = eventManagerGUID;
        this.eventManagerName = eventManagerName;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createTopic(boolean eventBrokerIsHome, TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createTopic(this.userId, this.eventManagerGUID, this.eventManagerName, eventBrokerIsHome, topicProperties);
    }

    public String createTopicFromTemplate(boolean eventBrokerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createTopicFromTemplate(this.userId, this.eventManagerGUID, this.eventManagerName, eventBrokerIsHome, templateGUID, templateProperties);
    }

    public void updateTopic(String topicGUID, boolean isMergeUpdate, TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateTopic(this.userId, this.eventManagerGUID, this.eventManagerName, topicGUID, isMergeUpdate, topicProperties);
    }

    public void publishTopic(String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishTopic(this.userId, topicGUID);
    }

    public void withdrawTopic(String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawTopic(this.userId, topicGUID);
    }

    public void removeTopic(String topicGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeTopic(this.userId, this.eventManagerGUID, this.eventManagerName, topicGUID, qualifiedName);
    }

    public List<TopicElement> findTopics(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findTopics(this.userId, searchString, startFrom, pageSize);
    }

    public List<TopicElement> getTopicsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopicsByName(this.userId, name, startFrom, pageSize);
    }

    public List<TopicElement> getMyTopics(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopicsForEventBroker(this.userId, this.eventManagerGUID, this.eventManagerName, startFrom, pageSize);
    }

    public TopicElement getTopicByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getTopicByGUID(this.userId, guid);
    }

    public String createEventType(boolean eventBrokerIsHome, String topicGUID, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createEventType(this.userId, this.eventManagerGUID, this.eventManagerName, eventBrokerIsHome, topicGUID, properties);
    }

    public String createEventTypeFromTemplate(boolean eventBrokerIsHome, String templateGUID, String topicGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createEventTypeFromTemplate(this.userId, this.eventManagerGUID, this.eventManagerName, eventBrokerIsHome, templateGUID, topicGUID, templateProperties);
    }

    public void updateEventType(String eventTypeGUID, boolean isMergeUpdate, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateEventType(this.userId, this.eventManagerGUID, this.eventManagerName, eventTypeGUID, isMergeUpdate, properties);
    }

    public void removeEventType(String eventTypeGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeEventType(this.userId, this.eventManagerGUID, this.eventManagerName, eventTypeGUID, qualifiedName);
    }

    public List<EventTypeElement> findEventTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findEventTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesForEventSet(String eventSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getEventTypesForEventSet(this.userId, eventSetGUID, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesForTopic(String topicGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getEventTypesForTopic(this.userId, topicGUID, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getEventTypesByName(this.userId, name, startFrom, pageSize);
    }

    public EventTypeElement getEventTypeByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getEventTypeByGUID(this.userId, guid);
    }

    public String createPrimitiveSchemaType(boolean eventManagerIsHome, PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createPrimitiveSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties);
    }

    public String createLiteralSchemaType(boolean eventManagerIsHome, LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createLiteralSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties);
    }

    public String createEnumSchemaType(boolean eventManagerIsHome, EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createEnumSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(boolean eventManagerIsHome, StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createStructSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(boolean eventManagerIsHome, SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaTypeChoice(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(boolean eventManagerIsHome, MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createMapSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(boolean eventManagerIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaTypeFromTemplate(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createSchemaAttribute(boolean eventManagerIsHome, String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaAttribute(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaElementGUID, schemaAttributeProperties);
    }

    public String createSchemaAttributeFromTemplate(boolean eventManagerIsHome, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createSchemaAttributeFromTemplate(this.userId, this.eventManagerGUID, this.eventManagerName, eventManagerIsHome, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.setupSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, schemaAttributeGUID, schemaTypeGUID);
    }

    public void clearSchemaType(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearSchemaType(this.userId, this.eventManagerGUID, this.eventManagerName, schemaAttributeGUID);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateSchemaAttribute(this.userId, this.eventManagerGUID, this.eventManagerName, schemaAttributeGUID, isMergeUpdate, schemaAttributeProperties);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeSchemaAttribute(this.userId, this.eventManagerGUID, this.eventManagerName, schemaAttributeGUID);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findSchemaAttributes(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getNestedAttributes(this.userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaAttributesByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaAttributeByGUID(this.userId, schemaAttributeGUID);
    }
}

