/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.topic.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.EventBrokerClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EventTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.TopicElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TopicProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class TopicIntegratorContext {
    private ConnectionManagerClient connectionManagerClient;
    private EventBrokerClient eventBrokerClient;
    private DataManagerEventClient eventClient;
    private String userId;
    private String eventBrokerGUID;
    private String eventBrokerName;
    private boolean eventBrokerIsHome = true;

    public TopicIntegratorContext(EventBrokerClient eventBrokerClient, ConnectionManagerClient connectionManagerClient, DataManagerEventClient eventClient, String userId, String eventBrokerGUID, String eventBrokerName) {
        this.eventBrokerClient = eventBrokerClient;
        this.connectionManagerClient = connectionManagerClient;
        this.eventClient = eventClient;
        this.userId = userId;
        this.eventBrokerGUID = eventBrokerGUID;
        this.eventBrokerName = eventBrokerName;
    }

    public void setEventBrokerIsHome(boolean eventBrokerIsHome) {
        this.eventBrokerIsHome = eventBrokerIsHome;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createTopic(TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.createTopic(this.userId, this.eventBrokerGUID, this.eventBrokerName, this.eventBrokerIsHome, topicProperties);
    }

    public String createTopicFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.createTopicFromTemplate(this.userId, this.eventBrokerGUID, this.eventBrokerName, this.eventBrokerIsHome, templateGUID, templateProperties);
    }

    public void updateTopic(String topicGUID, boolean isMergeUpdate, TopicProperties topicProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.updateTopic(this.userId, this.eventBrokerGUID, this.eventBrokerName, topicGUID, isMergeUpdate, topicProperties);
    }

    public void publishTopic(String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.publishTopic(this.userId, topicGUID);
    }

    public void withdrawTopic(String topicGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.withdrawTopic(this.userId, topicGUID);
    }

    public void removeTopic(String topicGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.removeTopic(this.userId, this.eventBrokerGUID, this.eventBrokerName, topicGUID, qualifiedName);
    }

    public List<TopicElement> findTopics(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.findTopics(this.userId, searchString, startFrom, pageSize);
    }

    public List<TopicElement> getTopicsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getTopicsByName(this.userId, name, startFrom, pageSize);
    }

    public List<TopicElement> getMyTopics(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getTopicsForEventBroker(this.userId, this.eventBrokerGUID, this.eventBrokerName, startFrom, pageSize);
    }

    public TopicElement getTopicByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getTopicByGUID(this.userId, guid);
    }

    public String createEventType(String topicGUID, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createEventType(this.userId, this.eventBrokerGUID, this.eventBrokerName, topicGUID, properties);
        }
        return this.eventBrokerClient.createEventType(this.userId, null, null, topicGUID, properties);
    }

    public String createEventTypeFromTemplate(String templateGUID, String topicGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createEventTypeFromTemplate(this.userId, this.eventBrokerGUID, this.eventBrokerName, templateGUID, topicGUID, templateProperties);
        }
        return this.eventBrokerClient.createEventTypeFromTemplate(this.userId, null, null, templateGUID, topicGUID, templateProperties);
    }

    public void updateEventType(String eventTypeGUID, boolean isMergeUpdate, EventTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.updateEventType(this.userId, this.eventBrokerGUID, this.eventBrokerName, eventTypeGUID, isMergeUpdate, properties);
    }

    public void removeEventType(String eventTypeGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.removeEventType(this.userId, this.eventBrokerGUID, this.eventBrokerName, eventTypeGUID, qualifiedName);
    }

    public List<EventTypeElement> findEventTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.findEventTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesForEventSet(String eventSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getEventTypesForEventSet(this.userId, eventSetGUID, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesForTopic(String topicGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getEventTypesForTopic(this.userId, topicGUID, startFrom, pageSize);
    }

    public List<EventTypeElement> getEventTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getEventTypesByName(this.userId, name, startFrom, pageSize);
    }

    public EventTypeElement getEventTypeByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getEventTypeByGUID(this.userId, guid);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createPrimitiveSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties);
        }
        return this.eventBrokerClient.createPrimitiveSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createLiteralSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties);
        }
        return this.eventBrokerClient.createLiteralSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createEnumSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties, validValuesSetGUID);
        }
        return this.eventBrokerClient.createEnumSchemaType(this.userId, null, null, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createStructSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties);
        }
        return this.eventBrokerClient.createStructSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createSchemaTypeChoice(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties, schemaTypeOptionGUIDs);
        }
        return this.eventBrokerClient.createSchemaTypeChoice(this.userId, null, null, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createMapSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        }
        return this.eventBrokerClient.createMapSchemaType(this.userId, null, null, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createSchemaTypeFromTemplate(this.userId, this.eventBrokerGUID, this.eventBrokerName, templateGUID, templateProperties);
        }
        return this.eventBrokerClient.createSchemaTypeFromTemplate(this.userId, null, null, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.updateSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.removeSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createSchemaAttribute(String schemaElementGUID, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createSchemaAttribute(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaElementGUID, schemaAttributeProperties);
        }
        return this.eventBrokerClient.createSchemaAttribute(this.userId, null, null, schemaElementGUID, schemaAttributeProperties);
    }

    public String createSchemaAttributeFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            return this.eventBrokerClient.createSchemaAttributeFromTemplate(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaElementGUID, templateGUID, templateProperties);
        }
        return this.eventBrokerClient.createSchemaAttributeFromTemplate(this.userId, null, null, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String relationshipTypeName, String schemaAttributeGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.eventBrokerIsHome) {
            this.eventBrokerClient.setupSchemaType(this.userId, this.eventBrokerGUID, this.eventBrokerName, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID);
        } else {
            this.eventBrokerClient.setupSchemaType(this.userId, null, null, relationshipTypeName, schemaAttributeGUID, schemaTypeGUID);
        }
    }

    public void clearSchemaTypes(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.clearSchemaTypes(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaAttributeGUID);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.updateSchemaAttribute(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaAttributeGUID, isMergeUpdate, schemaAttributeProperties);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.eventBrokerClient.removeSchemaAttribute(this.userId, this.eventBrokerGUID, this.eventBrokerName, schemaAttributeGUID);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.findSchemaAttributes(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getNestedAttributes(this.userId, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaAttributesByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.eventBrokerClient.getSchemaAttributeByGUID(this.userId, schemaAttributeGUID);
    }

    public String createConnection(ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnection(this.userId, null, null, connectionProperties);
    }

    public String createConnectionFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnectionFromTemplate(this.userId, null, null, templateGUID, templateProperties);
    }

    public void updateConnection(String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateConnection(this.userId, this.eventBrokerGUID, this.eventBrokerName, connectionGUID, isMergeUpdate, connectionProperties);
    }

    public void setupConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupConnectorType(this.userId, null, null, connectionGUID, connectorTypeGUID);
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearConnectorType(this.userId, this.eventBrokerGUID, this.eventBrokerName, connectionGUID, connectorTypeGUID);
    }

    public void setupEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEndpoint(this.userId, null, null, connectionGUID, endpointGUID);
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEndpoint(this.userId, this.eventBrokerGUID, this.eventBrokerName, connectionGUID, endpointGUID);
    }

    public void setupEmbeddedConnection(String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEmbeddedConnection(this.userId, null, null, connectionGUID, position, displayName, arguments, embeddedConnectionGUID);
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEmbeddedConnection(this.userId, this.eventBrokerGUID, this.eventBrokerName, connectionGUID, embeddedConnectionGUID);
    }

    public void setupAssetConnection(String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupAssetConnection(this.userId, null, null, assetGUID, assetSummary, connectionGUID);
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearAssetConnection(this.userId, this.eventBrokerGUID, this.eventBrokerName, assetGUID, connectionGUID);
    }

    public void removeConnection(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeConnection(this.userId, this.eventBrokerGUID, this.eventBrokerName, connectionGUID);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnections(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionsByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionByGUID(this.userId, connectionGUID);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpoint(this.userId, null, null, endpointProperties);
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpointFromTemplate(this.userId, null, null, networkAddress, templateGUID, templateProperties);
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.eventBrokerGUID, this.eventBrokerName, isMergeUpdate, endpointGUID, endpointProperties);
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.eventBrokerGUID, this.eventBrokerName, endpointGUID);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnectorTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypesByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypeByGUID(this.userId, connectorTypeGUID);
    }
}

