/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.topic.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.EventBrokerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventBrokerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorConnector;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorContext;
import org.odpi.openmetadata.integrationservices.topic.ffdc.TopicIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.topic.ffdc.TopicIntegratorErrorCode;

public class TopicIntegratorContextManager
extends IntegrationContextManager {
    private EventBrokerClient eventBrokerClient = null;
    private ConnectionManagerClient connectionManagerClient = null;
    private MetadataSourceClient metadataSourceClient = null;
    private DataManagerRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", TopicIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        this.restClient = this.localServerPassword == null ? new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.eventBrokerClient = new EventBrokerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
        this.connectionManagerClient = new ConnectionManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.metadataSourceClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            EventBrokerProperties properties = new EventBrokerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.metadataSourceClient.createEventBroker(this.localServerUserId, null, null, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization, Map<String, Object> serviceOptions) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (serviceOptions != null) {
            serviceOptionsString = serviceOptions.toString();
        }
        if (!(integrationConnector instanceof TopicIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(TopicIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.TOPIC_INTEGRATOR_OMIS.getIntegrationServiceFullName(), TopicIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", TopicIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        TopicIntegratorConnector serviceSpecificConnector = (TopicIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        DataManagerEventClient dataManagerEventClient = new DataManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
        serviceSpecificConnector.setContext(new TopicIntegratorContext(this.eventBrokerClient, this.connectionManagerClient, dataManagerEventClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName));
    }
}

