/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.topic.rest;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorConnector;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorOMISConnector;
import org.odpi.openmetadata.integrationservices.topic.contextmanager.TopicIntegratorContextManager;
import org.slf4j.LoggerFactory;

public class TopicIntegratorRESTServices {
    private static final IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(TopicIntegratorRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public TopicIntegratorRESTServices() {
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.TOPIC_INTEGRATOR_OMIS, (String)TopicIntegratorContextManager.class.getName(), (String)TopicIntegratorOMISConnector.class.getName());
    }

    public ConnectorReportResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorReportResponse response = new ConnectorReportResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, TopicIntegratorConnector.class, IntegrationServiceDescription.TOPIC_INTEGRATOR_OMIS.getIntegrationServiceFullName());
            if (connectorReport != null) {
                response.setConnectorReport(connectorReport);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

