/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.topic.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.EventBrokerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.datamanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.datamanager.client.ValidValueManagement;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventBrokerProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorConnector;
import org.odpi.openmetadata.integrationservices.topic.connector.TopicIntegratorContext;
import org.odpi.openmetadata.integrationservices.topic.ffdc.TopicIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.topic.ffdc.TopicIntegratorErrorCode;

public class TopicIntegratorContextManager
extends IntegrationContextManager {
    private EventBrokerClient eventBrokerClient = null;
    private ConnectionManagerClient connectionManagerClient = null;
    private MetadataSourceClient metadataSourceClient = null;
    private ValidValueManagement validValueManagement = null;
    private DataManagerRESTClient restClient = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", TopicIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        this.restClient = this.localServerPassword == null ? new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new DataManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.eventBrokerClient = new EventBrokerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.connectionManagerClient = new ConnectionManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize, this.auditLog);
        this.validValueManagement = new ValidValueManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.restClient, this.maxPageSize);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (metadataSourceQualifiedName != null) {
            String metadataSourceGUID = this.metadataSourceClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
            if (metadataSourceGUID == null) {
                EventBrokerProperties properties = new EventBrokerProperties();
                properties.setQualifiedName(metadataSourceQualifiedName);
                metadataSourceGUID = this.metadataSourceClient.createEventBroker(this.localServerUserId, null, null, properties);
            }
            return metadataSourceGUID;
        }
        return null;
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof TopicIntegratorConnector) {
            this.auditLog.logMessage("setContext", TopicIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            TopicIntegratorConnector serviceSpecificConnector = (TopicIntegratorConnector)integrationConnector;
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            DataManagerEventClient dataManagerEventClient = new DataManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)this.restClient, this.maxPageSize, this.auditLog, connectorId);
            TopicIntegratorContext integratorContext = new TopicIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.openMetadataStoreClient, this.eventBrokerClient, this.connectionManagerClient, this.validValueManagement, dataManagerEventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, this.maxPageSize);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(TopicIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.TOPIC_INTEGRATOR_OMIS.getIntegrationServiceFullName(), TopicIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

